/*************************[ SoftC Libraries ]*****************************
** Copyright (c) 1986, 1997 SoftC, Ltd.
** All Rights Reserved.
**************************************************************************
**
**      This module contains low level file i/o macros & definitions.
**/

/************************[ compilation switches ]************************/
#ifndef __SCFILE_DOT_H__
/****************************[ header files ]****************************/
/************************[ constant definitions ]************************/
#define __SCFILE_DOT_H__

#ifdef _MAX_PATH
#define SC_MAX_PATH _MAX_PATH
#elif defined(MAX_PATH)
#define SC_MAX_PATH MAX_PATH
#elif defined(MAXPATH)
#define SC_MAX_PATH MAXPATH
#endif

#if defined( SC_WIN32 )
typedef HANDLE SCFILEHANDLE;
#define SCINVALIDFILEHANDLE INVALID_HANDLE_VALUE
#elif defined( SC_ANSI )
typedef FILE * SCFILEHANDLE;
#define SCINVALIDFILEHANDLE SCNULL
#else
typedef SCINT SCFILEHANDLE;
#define SCINVALIDFILEHANDLE (SCINT)-1
#endif
#define SCFILEHANDLEP SCFILEHANDLE SC_FAR_POINTER

#define SCTRUE 1
#define SCFALSE 0

#define SCSUCCESS       0       /* no error or warning */

/* General Warnings */
#define SCWAR_00001     1       /* file not found */
#define SCWAR_00002     2       /* function not supported */

#ifdef OLD_WARNINGS
/* old warnings */
#define DCNOTFOUND      SCWAR_00001
#define DCNOFUNC        SCWAR_00002
#endif

/* General Errors */
#define SCERR_00001     -1      /* invalid file handle */
#define SCERR_00002     -2      /* file does not exist */
#define SCERR_00003     -3      /* invalid file path specification */
#define SCERR_00004     -4      /* no file handles available */
#define SCERR_00005     -5      /* access to file denied */
#define SCERR_00006     -6      /* invalid file access code */
#define SCERR_00007     -7      /* invalid command */
#define SCERR_00008     -8      /* parameter address NULL */
#define SCERR_00009     -9      /* file pointer reposition failed */
#define SCERR_00010     -10     /* incomplete file write */
#define SCERR_00011     -11     /* incomplete file read */
#define SCERR_00012     -12     /* general flush failure */
#define SCERR_00014     -14     /* file locking violation */
#define SCERR_00015     -15     /* memory allocation failure */
#define SCERR_00016     -16     /* read only file */
#define SCERR_00017     -17     /* general file open failure */
#define SCERR_00018     -18     /* invalid file name */
#define SCERR_00019     -19     /* destination device changed */
#define SCERR_00020     -20     /* locking buffer underflow */
#define SCERR_00021     -21     /* locking buffer overflow */
#define SCERR_00022     -22     /* task lookup failure */
#define SCERR_00023     -23     /* some files remain open */
#define SCERR_00024     -24     /* disk full */
#define SCERR_00025     -25     /* device changed */
#define SCERR_00026     -26     /* lock violation */
#define SCERR_00027     -27     /* flush failure */
#define SCERR_00028     -28     /* invalid date */
#define SCERR_00029     -29     /* invalid time */
#define SCERR_00030     -30     /* file close failure */
#define SCERR_00031     -31     /* file must be locked first */
#define SCERR_00032     -32     /* Windows GlobalLock failed */

#ifdef OLD_ERRORS
/* old errors */
#define DCHANDLE        SCERR_00001
#define DCFILENAME      SCERR_00018
#define DCSEEKFAIL      SCERR_00009
#define DCWRITEFAIL     SCERR_00010
#define DCOPENFAIL      SCERR_00017
#define DCLOCKBFROVER   SCERR_00021
#define DCACCESSCODE    SCERR_00006
#define DCACCESSDENIED  SCERR_00005
#define DCNULLPARAM     SCERR_00008
#define DCCOMMAND       SCERR_00007
#define DCNOHANDLE      SCERR_00004
#define DCNOPATH        SCERR_00003
#define DCNOFILE        SCERR_00002
#define DCREADFAIL      SCERR_00011
#define DCNOMEMORY      SCERR_00015
#define DCREADONLYFILE  SCERR_00016
#define DCLOCKBFRUNDER  SCERR_00020
#define DCTASKLOOKUP    SCERR_00022
#define DCFILESOPEN     SCERR_00023
#define DCDISKFULL      SCERR_00024
#define DBNEWDEVICE     SCERR_00025
#define DBLOCKVIOLATE   SCERR_00026
#define DBFLUSHFAIL     SCERR_00027
#define DBDATE          SCERR_00028
#define DBTIME          SCERR_00029
#define DBCLOSEFAIL     SCERR_00030
#define DBNOTLOCKED     SCERR_00031
#define DBMEMORYLOCK    SCERR_00032
#endif

#define SCOPENREADWRITE 0         /* read/write access (default)            */
#define SCOPENREADONLY 0x100      /* read only access                       */
#define SCOPENBUFFERED 0          /* buffer disk writes in memory (default) */
#define SCOPENFLUSHED 0x80        /* force all writes to disk               */
#define SCOPENEXCLUSIVE 0         /* open file for exclusive use (default)  */
#define SCOPENSHARED 0x40         /* open file for shared use               */
#define SCOPENMANUALLOCK 0        /* apply locks manually                   */
#define SCOPENAUTOLOCKS 0x20      /* apply locks automatically              */
#define SCOPENSYSBUFFERED 0x1000  /* buffer read/write in OS buffers        */
#define SCOPENMULTILOCKS 0x2000   /* allow multiple record locks            */
#define SCOPENAPPEND 0x4000       /* allow appending only */
#define SCREUSEDELETED 0x8000     /* reuse deleted records */
#define SCOPENSTANDARD (SCOPENREADWRITE|SCOPENBUFFERED|SCOPENEXCLUSIVE|SCOPENMANUALLOCK) /* Standard open */
#define SCOPENLAN (SCOPENFLUSHED|SCOPENSHARED) /* typical (shared and flushed) */

#define SCUSEXTRAHANDLES 0x100    /* allow more than 20 open files */

/* file attributes */
#define SC_FA_READ_ONLY  0x0001l
#define SC_FA_HIDDEN     0x0002l
#define SC_FA_SYSTEM     0x0004l
#define SC_FA_LABEL      0x0008l
#define SC_FA_DIRECTORY  0x0010l
#define SC_FA_ARCHIVED   0x0020l
#define SC_FA_COMPRESSED 0x0040l
#define SC_FA_TEMPORARY  0x0080l

/****************************[ enumerations ]****************************/
/**************************[ macro defintions ]**************************/
#ifdef _DEBUG
#define SCLOGERROR(a) _SCErrorWrite(module_name,__LINE__,a)
#else
#define SCLOGERROR(a)
#endif
#define SCMKFP(p,seg,ofs)  {(*((SCUINT *)&(p) + 1)) = seg; \
		    (*((SCUINT *)&(p))) = ofs;}

/**************************[ type definitions ]**************************/
typedef struct
{
#ifdef SC_WIN32
   HANDLE   hSearch;   /* search handle                */
#endif
   SCLONG   lSearch;   /* search file attributes       */
   SCLONG   lAttrib;   /* DOS style file attributes    */
   SCUSHORT unTime;    /* DOS style last modified time */
   SCUSHORT unDate;    /* DOS style last modified date */
   SCLONG   lSize;     /* length of file in bytes      */
   SCCHAR   szFileName[SC_MAX_PATH]; /* file name  */
} SC_FIND;
#define SC_FINDP SC_FIND SC_FAR_POINTER

typedef struct
{
   SCULONG      lFileLockAddress;      /* address of file lock */
   SCULONG      lFileLockLength;       /* length of file lock */
   SCULONG      lHeaderLockAddress;    /* address of header lock */
   SCULONG      lHeaderLockLength;     /* length of header lock */
   SCLONG       lOffset;               /* current position in file */
   SCLONG       lFileSize;             /* length of file */
   SCLONG       lFirstFree;            /* start of free block thread */
   SCFILEHANDLE file;                  /* archive file handle */
   SCUINT       packetType:3;          /* packet type */
   SCUINT       bUpdated:1;            /* file modified */
   SCUINT       bAppended:1;           /* data appended */
   SCUINT       bWriteFlush:1;         /* flush disk output to file */
   SCUINT       bReadOnly:1;           /*    read only     */
   SCUINT       bFlush:1;              /*    always flush  */
   SCUINT       bShared:1;             /*    shared file   */
   SCUINT       bAutoLocks:1;          /*    auto locks    */
   SCUINT       bMultilocks:1;         /*    multi locks   */
   SCUINT       bReadHeader:1;         /* read header information */
   SCUINT       bReuseDeleted:1;       /* reuse deleted records */
   SCUINT       bFileLocked:1;         /* file lock applied */
   SCUINT       bHeaderLocked:1;       /* header lock applied */
   SCUINT       bRecordLocked:1;       /* record lock applied */
   SCINT        wTransactionLog;       /* transaction log file handle */
#if defined( SC_ANSI )
   SCINT        handle;                /* file handle */
#endif
   SCSHORT      nHeaderLength;         /* length of file header */
   SCSHORT      nBlockSizeAdder;       /* length of standard block */
   SCCHAR       szFileName[SC_MAX_PATH]; /* full filename */
} SCFILE;
#define SCFILEP SCFILE SC_FAR_POINTER
#define SCFILEPP SCFILE SC_FAR_POINTER SC_FAR_POINTER

typedef struct {  /* lock structure */
   SCULONG address;    /* lock begin address */
   SCULONG length;     /* lock region length */
#ifdef SC_WIN32
   HANDLE   fileHandle; /* file handle */
#else
   SCINT    fileHandle; /* file handle */
#endif
}  SCLOCK;
#define SCLOCKP SCLOCK SC_FAR_POINTER

typedef struct {  /* control parameters */
   SCFILEPP   packet;        /* packet array */
   SCLOCKP    locks;         /* locks array */
   SCSHORT    locksUsed;     /* number of locks currently applied */
   SCSHORT    maxLocks;      /* maximum number of locks available */
   SCSHORT    maxSoftFiles;  /* maximum number of soft files open */
   SCSHORT    softFilesOpen; /* current number of soft files open */
}  SCTASKPKT;
#define SCTASKPKTP SCTASKPKT SC_FAR_POINTER

#if defined( SC_BUILDING_DLL ) && defined( SC_WIN16 )
typedef struct {
   HANDLE    taskHandle;       /* task handle */
   SCINT     errorNumber;
   SCINT     dateStyle;        /* date style */
   SCINT     logErrors;        /* log errors to disk file flag */
   SCINT     lockRetry;        /* maximum lock retry count */
   SCTASKPKT SCbase;           /* control structure for this task */
   SCUCHAR   logFilename[30];  /* log file name */
}  SCTASK;
#define SCTASKP SCTASK SC_FAR_POINTER
#endif

/************************[ structure defintions ]************************/
/*************************[ class definitions ]**************************/
/************************[ variable definitions ]************************/
/************************[ external declarations ]***********************/
#if defined( __cplusplus )
extern "C" {
#endif

extern SCTASKPKT   SCbase;            /* SoftC control structure */
extern SCINT       SCerrno;           /* error number */
extern SCINT       SClockRetry;
extern SCINT       SCinitCount;
extern SCUCHAR     SCbuffer[4096];    /* buffer */
extern SCINT       SCreadLength;

#if defined( SC_BUILDING_DLL ) && defined( SC_WIN16 )
extern SCINT       SCnumtasks;
extern SCTASKP     SCtasksa;
#endif

#if defined( SC_WINDOWS ) && defined( SC_WIN16 )
extern OFSTRUCT    SCopenbuff;        /* Windows open file buffer */
#endif

#if defined( __cplusplus )
}
#endif

/*************************[ function prototypes ]************************/
#if defined( __cplusplus )
extern "C" {
#endif

SCINT SCosDeleteFile( CONST SCCHARP );
SCINT SCosIsFileThere( CONST SCCHARP );
SCINT SCosRenameFile( CONST SCCHARP, CONST SCCHARP );
SCINT SCosCloseFile( SCFILEP );
SCINT SCosCreateFile( SCFILEP, CONST SCCHARP, CONST SCINT );
SCINT SCosEndOfFile( SCFILEP, SCUCHARP );
SCINT SCosFlushFile( SCFILEP );
SCINT SCosFileLength( SCFILEP, SCLONGP );
SCINT SCosFindFirst( SC_FINDP, CONST SCCHARP, CONST SCLONG);
SCINT SCosFindNext( SC_FINDP );
SCINT SCosFindClose( SC_FINDP );
SCINT SCosGetCurDir( SCCHARP );
SCINT SCosGetFileAttrib( CONST SCCHARP, SCLONGP );
SCINT SCosGetFileDate( SCFILEP, SCUSHORTP, SCUSHORTP );
SCINT SCosGetFilePosition( SCFILEP, SCLONGP );
SCINT SCosLockData( SCFILEP, CONST SCINT, CONST SCLONG, CONST SCLONG );
SCINT SCosMakeDir( CONST SCCHARP );
SCINT SCosReadData( SCFILEP, SCVOIDP, CONST SCINT );
SCINT SCosSetCurDir( CONST SCCHARP );
SCINT SCosSetFileAttrib( CONST SCCHARP, CONST SCLONG );
SCINT SCosSetFileDate( SCFILEP, CONST SCUSHORT, CONST SCUSHORT );
SCINT SCosSetFilePosition( SCFILEP, CONST SCLONG );
SCINT SCosSetFileSize( SCFILEP, CONST SCLONG );
SCINT SCosTestLock( SCFILEP, CONST SCLONG, CONST SCLONG );
SCINT SCosWriteData( SCFILEP, CONST SCVOIDP, CONST SCINT, CONST SCSHORT );
SCINT SCosOpenFile( SCFILEP, CONST SCCHARP, CONST SCINT);

#ifdef SC_WIN32
SCVOID _SCFlagLock( CONST HANDLE, CONST SCINT, CONST SCLONG, CONST SCLONG );
#else
SCVOID _SCFlagLock( CONST SCINT, CONST SCINT, CONST SCLONG, CONST SCLONG );
#endif
#if defined( SC_BUILDING_DLL ) && defined( SC_WIN16 )
SCINT _sctask( SCVOID );
SCINT _SCSaveTask( SCVOID );
#endif
SCINT _SCSetLocksUsed ( CONST SCINT );

/*  Miscellaneous Functions */
SCVOID _SCErrorWrite( CONST SCCHARP, CONST SCINT, CONST SCINT );
SCVOID _SCYieldTime( SCVOID );

#if defined( __cplusplus )
}
#endif

#endif
