/**************************[ SoftC Libraries ]****************************
** Copyright (c) 1994, 1997 SoftC, Ltd.
** All Rights Reserved.
**************************************************************************
**
**      This module contains common macros & definitions.
**/

/************************[ compilation switches ]************************/
#ifndef __SCCOMMON_DOT_H__

/****************************[ header files ]****************************/
/************************[ constant definitions ]************************/
#define __SCCOMMON_DOT_H__

/****************************[ enumerations ]****************************/
enum {
   DBDATA,
   DBMEMO,
   DBINDEX,
   DBLOG,
   __SCLAST
};

/**************************[ macro defintions ]**************************/
#define _SCmax(a,b) ((a) < (b) ? (b) : (a))
#define _SCmin(a,b) ((a) > (b) ? (b) : (a))

#define SCMKFP(p,seg,ofs)  {(*((SCUINT *)&(p) + 1)) = seg; \
		    (*((SCUINT *)&(p))) = ofs;}

#define _SCstrupr(a) {SCINT zz=0; \
	      while((a)[zz] != 0) { \
	      (a)[zz] = (SCCHAR)toupper((a)[zz]); \
	      zz++;}}

#define _SCstrlwr(a) {DSCINT zz=0; \
	      while((a)[zz] != 0) { \
	      (a)[zz] = (SCCHAR)tolower((a)[zz]); \
	      zz++;}}

/*
 *  Macro definitions for endian conversion
 */

#ifdef __BIG_ENDIAN__
 #define _SCLongBigToNative(a)        (a)
 #define _SCLongLittleToNative(a)     _SCSwapBytesLong(a)
 #define _SCLongNativeToBig(a)        (a)
 #define _SCLongNativeToLittle(a)     _SCSwapBytesLong(a)
 #define _SCShortBigToNative(a)       (a)
 #define _SCShortLittleToNative(a)    _SCSwapBytesShort(a)
 #define _SCShortNativeToBig(a)       (a)
 #define _SCShortNativeToLittle(a)    _SCSwapBytesShort(a)
 #define _SCFloatBigToNative(a,b)     _SCmemmove(a,b,sizeof(SCFLOAT))
 #define _SCFloatLittleToNative(a,b)  _SCSwapBytesFloat(a,b)
 #define _SCFloatNativeToBig(a,b)     _SCmemmove(a,b,sizeof(SCFLOAT))
 #define _SCFloatNativeToLittle(a,b)  _SCSwapBytesFloat(a,b)
 #define _SCDoubleBigToNative(a,b)    _SCmemmove(a,b,sizeof(SCDOUBLE))
 #define _SCDoubleLittleToNative(a,b) _SCSwapBytesDouble(a,b)
 #define _SCDoubleNativeToBig(a,b)    _SCmemmove(a,b,sizeof(SCDOUBLE))
 #define _SCDoubleNativeToLittle(a,b) _SCSwapBytesDouble(a,b)
#else
 #define _SCLongLittleToNative(a)     (a)
 #define _SCLongBigToNative(a)        _SCSwapBytesLong(a)
 #define _SCLongNativeToLittle(a)     (a)
 #define _SCLongNativeToBig(a)        _SCSwapBytesLong(a)
 #define _SCShortLittleToNative(a)    (a)
 #define _SCShortBigToNative(a)       _SCSwapBytesShort(a)
 #define _SCShortNativeToLittle(a)    (a)
 #define _SCShortNativeToBig(a)       _SCSwapBytesShort(a)
 #define _SCFloatLittleToNative(a,b)  _SCmemmove(a,b,sizeof(SCFLOAT))
 #define _SCFloatBigToNative(a,b)     _SCSwapBytesFloat(a,b)
 #define _SCFloatNativeToLittle(a,b)  _SCmemmove(a,b,sizeof(SCFLOAT))
 #define _SCFloatNativeToBig(a,b)     _SCSwapBytesFloat(a,b)
 #define _SCDoubleLittleToNative(a,b) _SCmemmove(a,b,sizeof(SCDOUBLE))
 #define _SCDoubleBigToNative(a,b)    _SCSwapBytesDouble(a,b)
 #define _SCDoubleNativeToLittle(a,b) _SCmemmove(a,b,sizeof(SCDOUBLE))
 #define _SCDoubleNativeToBig(a,b)    _SCSwapBytesDouble(a,b)
#endif

/**********
 *
 *  Memory and String Function Definitions
 *
 **********/

#if defined( SC_BUILDING_DLL ) || defined( SC_USING_DLL )
 #if defined( SC_WIN32 )
  #define _SCstrcpy(a,b)      strcpy(a,b)
  #define _SCstrcat(a,b)      strcat(a,b)
  #define _SCstrlen(a)        strlen(a)
  #define _SCstrcmp(a,b)      strcmp(a,b)
  #define _SCstricmp(a,b)     stricmp(a,b)
  #define _SCstrrchr(a,b)     strrchr(a,b)
  #define _SCstrstr(a,b)      strstr(a,b)
  #define _SCmemcpy(a,b,c)    memcpy(a,b,c)
  #define _SCmemchr(a,b,c)    memchr(a,b,c)
  #define _SCmemcmp(a,b,c)    memcmp(a,b,c)
  #define _SCmemmove(a,b,c)   memmove(a,b,c)
  #define _SCmemset(a,b,c)    memset(a,b,c)
 #else
  #define _SCstrcpy(a,b)      _fstrcpy(a,b)
  #define _SCstrcat(a,b)      _fstrcat(a,b)
  #define _SCstrlen(a)        _fstrlen(a)
  #define _SCstrcmp(a,b)      _fstrcmp(a,b)
  #define _SCstricmp(a,b)     _fstricmp(a,b)
  #define _SCstrrchr(a,b)     _fstrrchr(a,b)
  #define _SCstrstr(a,b)      _fstrstr(a,b)
  #define _SCmemcpy(a,b,c)    _fmemcpy(a,b,c)
  #define _SCmemchr(a,b,c)    _fmemchr(a,b,c)
  #define _SCmemcmp(a,b,c)    _fmemcmp(a,b,c)
  #define _SCmemmove(a,b,c)   memmove(a,b,c)
  #define _SCmemset(a,b,c)    _fmemset(a,b,c)
 #endif
 #define _SCGetErrorCode()   SCGetErrorCode()
 #define _SCSetErrorCode(a)  SCSetErrorCode(a)

/* Local memory functions */
 SCINTF _SCAllocLocalMemory( SCVOIDPP, SCUINT );
 SCINTF _SCReAllocLocalMemory( SCVOIDPP, SCUINT );
 SCINTF _SCFreeLocalMemory( SCVOIDP );
#else
 #define _SCstrcpy(a,b)      strcpy(a,b)
 #define _SCstrcat(a,b)      strcat(a,b)
 #define _SCstrlen(a)        strlen(a)
 #define _SCstrcmp(a,b)      strcmp(a,b)
 #ifdef __STRCMPI_DEF__
  #define _SCstricmp(a,b)     strcmpi(a,b)
 #else
  #ifdef ANSI_PROTOTYPES
   SCINT _SCstricmp( SCCHARP, SCCHARP );
  #endif
 #endif
 #ifdef __MEMMOVE_DEF__
  #define _SCmemmove(a,b,c) memmove(a,b,c)
 #else
  #ifdef ANSI_PROTOTYPES
   SCVOIDP _SCmemmove( SCVOIDP, CONST SCVOIDP, SCUINT );
  #endif
 #endif
 #define _SCstrrchr(a,b)     strrchr(a,b)
 #define _SCstrstr(a,b)      strstr(a,b)
 #define _SCmemcpy(a,b,c)    memcpy(a,b,c)
 #define _SCmemchr(a,b,c)    memchr(a,b,c)
 #define _SCmemcmp(a,b,c)    memcmp(a,b,c)
 #define _SCmemset(a,b,c)    memset(a,b,c)
 #define _SCGetErrorCode()   (SCerrno)
 #define _SCSetErrorCode(a)  (SCerrno = a)
#endif

#if defined( SC_WINDOWS ) && !defined( SC_WIN32 )
  #define ULEN SCULONG
  #define SCNULL 0
  #define SCstrlen(a)         _fstrlen(a)
  #define SCstrcmp(a,b)       _fstrcmp(a,b)
  #define SCstricmp(a,b)      _fstricmp(a,b)
  #define SCstrrchr(a,b)      _fstrrchr(a,b)
  #define SCstrstr(a,b)       _fstrstr(a,b)
  #define SCmemcpy(a,b,c)     _fmemcpy(a,b,c)
  #define SCmemchr(a,b,c)     _fmemchr(a,b,c)
  #define SCmemcmp(a,b,c)     _fmemcmp(a,b,c)
  #define SCmemset(a,b,c)     _fmemset(a,b,c)
#else
  #if defined( SC_WIN32 )
    #define ULEN SCULONG
    #define SCNULL 0
  #else
    #define ULEN SCUINT
    #define SCNULL NULL
  #endif
  #define SCstrlen(a)         strlen(a)
  #define SCstrcmp(a,b)       strcmp(a,b)
  #ifdef __STRCMPI_DEF__
    #define SCstricmp(a,b)      strcmpi(a,b)
  #endif
  #define SCstrrchr(a,b)      strrchr(a,b)
  #define SCstrstr(a,b)       strstr(a,b)
  #define SCmemcpy(a,b,c)     memcpy(a,b,c)
  #define SCmemchr(a,b,c)     memchr(a,b,c)
  #define SCmemcmp(a,b,c)     memcmp(a,b,c)
  #define SCmemset(a,b,c)     memset(a,b,c)
#endif

#define SCClearErrorCode() SCSetErrorCode(SCSUCCESS)

/* Lower-case Function Name Definitions */
#define scallocatememory    SCAllocateMemory
#define scfreememory        SCFreeMemory
#define scgeterrorcode      SCGetErrorCode
#define scgetlockcount      SCGetLockCount
#define scgetlockretrycount SCGetLockRetryCount
#define scinitialize        SCInitialize
#define scmemchr            SCmemchr
#define scmemcmp            SCmemcmp
#define scmemcpy            SCmemcpy
#define scmemset            SCmemset
#define screallocatememory  SCReAllocateMemory
#define scseterrorcode      SCSetErrorCode
#define scsetlockcount      SCSetLockCount
#define scsetlockretrycount SCSetLockRetryCount
#define scstrcmp            SCstrcmp
#define scstricmp           SCstricmp
#define scstrlen            SCstrlen
#define scstrrchr           SCstrrchr
#define scstrstr            SCstrstr
#define scterminate         SCTerminate
#define scstrleft           SCstrleft
#define scstrltrim          SCstrltrim
#define scstrmid            SCstrmid
#define scstrright          SCstrright
#define scstrrtrim          SCstrrtrim
#define scstrtrim           SCstrtrim
#define scxstrcmp           SCxstrcmp
#define scconvertdatestr    SCConvertDateStr
#define scdate3tolong           SCDate3ToLong
#define scdate3tostr            SCDate3ToStr
#define scdayofweek             SCDayOfWeek
#define scdaysbetweenstr        SCDaysBetweenStr
#define scdaysinmonth           SCDaysInMonth
#define scdaysinmonthstr        SCDaysInMonthStr
#define scgetdate3              SCGetDate3
#define scgetdatestr            SCGetDateStr
#define scgetdefaultdatestyle   SCGetDefaultDateStyle
#define scgettime3              SCGetTime3
#define scgettimestr            SCGetTimeStr
#define scisleapyear            SCIsLeapYear
#define scisstrleapyear         SCIsStrLeapYear
#define scisvaliddatestr        SCIsValidDateStr
#define scisvalidtimestr        SCIsValidTimeStr
#define sclongdateto3           SCLongDateTo3
#define sclongdatetodayofweek   SCLongDateToDayOfWeek
#define sclongdatetostr         SCLongDateToStr
#define scmonthtostr            SCMonthToStr
#define scsecondsbetweenstr     SCSecondsBetweenStr
#define scsetdefaultdatestyle   SCSetDefaultDateStyle
#define scstrdateto3            SCStrDateTo3
#define scstrdatetodayofweek    SCStrDateToDayOfWeek
#define scstrdatetointdayweek   SCStrDateToIntDayWeek
#define scstrdatetolong         SCStrDateToLong
#define scstrdatetomonth        SCStrDateToMonth
#define scstrtimeto3            SCStrTimeTo3
#define sctime3tostr            SCTime3ToStr

#define SCLONGDATE      1
#define SCGREGORIAN     2     /* Gregorian date "mm/dd/yy" */
#define SCLONGGREGORIAN 3     /* Gregorian date "mm/dd/yyyy" */
#define SCANSI          4     /* ANSI date "yy.mm.dd" */
#define SCLONGANSI      5     /* ANSI date "yyyy.mm.dd" */
#define SCGERMAN        6     /* German date "dd.mm.yy" */
#define SCLONGGERMAN    7     /* German date "dd.mm.yyyy" */
#define SCBRITISH       8     /* British date "dd/mm/yy" */
#define SCLONGBRITISH   9     /* British date "dd/mm/yyyy" */
#define SCFRENCH       10     /* French date "dd/mm/yy" */
#define SCLONGFRENCH   11     /* French date "dd/mm/yyyy" */
#define SCITALIAN      12     /* Italian date "dd-mm-yy" */
#define SCLONGITALIAN  13     /* Italian date "dd-mm-yyyy" */
#define SCJAPAN        14     /* Japanese date "yy/mm/dd" */
#define SCLONGJAPAN    15     /* Japanese date "yyyy/mm/dd" */
#define SCUSA          16     /* USA date "mm-dd-yy" */
#define SCLONGUSA      17     /* USA date "mm-dd-yyyy" */
#define SCMDY          18     /* "mm/dd/yy" */
#define SCMDYY         19     /* "mm/dd/yyyy" */
#define SCYMD          20     /* "yy/mm/dd" */
#define SCYYMD         21     /* "yyyy/mm/dd" */
#define SCYYYYMMDD     23     /* dBASE date "yyyymmdd" */
#define SCDDMMYY       24     /* European Military date "ddmmyy" */
#define SCJULIAN       27     /* Julian date "yyyy/ddd" */
#define SCMAXDATESTYLE 27

#define SCHHMMSS        1     /* colon separated time "hh:mm:ss" */
#define SCMILITARY      2     /* Military time 0000 - 2359 */
#define SCMAXTIMESTYLE 2

/************************[ structure defintions ]************************/
/**************************[ type definitions ]**************************/
#ifdef SC_WINDOWS
typedef SCINT (FAR PASCAL *PTF)(SCINT); /* file close function */
#else
typedef SCINT (*PTF)(SCINT);  /* file close function */
#endif

/*************************[ class definitions ]**************************/
/************************[ variable definitions ]************************/
/************************[ external declarations ]***********************/
extern PTF    SCcloseFuncs[__SCLAST]; /* pointers to close functions */
extern SCCHAR SCdpm[13];
extern SCINT  SCdateStyle;

/*************************[ function prototypes ]************************/
#ifdef __cplusplus
extern "C" {
#endif

SCINTF SCAllocateMemory( SCVOIDPP, CONST ULEN );
SCINTF SCConvertDateStr( SCCHARP, CONST SCINT, CONST SCCHARP, CONST SCINT );
SCINTF SCDate3ToLong( SCLONGP, CONST SCINT, CONST SCINT, CONST SCINT );
SCINTF SCDate3ToPacked( SCUSHORTP, CONST SCINT, CONST SCINT, CONST SCINT );
SCINTF SCDate3ToStr( SCCHARP, CONST SCINT, CONST SCINT, CONST SCINT, CONST SCINT );
SCINTF SCDayOfWeek( SCCHARP, CONST SCINT );
SCINTF SCDaysBetweenStr( SCLONGP, CONST SCCHARP, CONST SCINT, CONST SCCHARP, CONST SCINT );
SCINTF SCDaysInMonth( SCINTP, CONST SCINT, CONST SCINT);
SCINTF SCDaysInMonthStr( SCINTP, CONST SCCHARP, CONST SCINT );
SCINTF SCErrorLog( CONST SCINT, CONST SCCHARP );
SCINTF SCFreeMemory( CONST SCVOIDP );
SCINTF SCGetDate3( SCINTP, SCINTP, SCINTP, SCINTP );
SCINTF SCGetDateStr( SCCHARP, CONST SCINT );
SCINTF SCGetDefaultDateStyle( SCINTP, SCCHARP );
SCINTF SCGetErrorCode( SCVOID );
SCCHARPF SCGetErrorStr( SCVOID );
SCINTF SCGetLockCount( SCINTP, SCINTP );
SCINTF SCGetLockRetryCount( SCINTP );
SCINTF SCGetTime3( SCINTP, SCINTP, SCINTP, SCINTP );
SCINTF SCGetTimeStr( SCCHARP, CONST SCINT );
SCINTF SCInitialize( CONST SCINT, CONST SCINT );
SCINTF SCIsLeapYear( CONST SCINT );
SCINTF SCIsStrLeapYear( CONST SCCHARP, CONST SCINT );
SCINTF SCIsValidDateStr( CONST SCCHARP, CONST SCINT );
SCINTF SCIsValidTimeStr( CONST SCCHARP, CONST SCINT );
SCINTF SCLongDateTo3( SCINTP, SCINTP, SCINTP, CONST SCLONG );
SCINTF SCLongDateToDayOfWeek( SCINTP, CONST SCLONG );
SCINTF SCLongDateToStr( SCCHARP, CONST SCINT, CONST SCLONG);
SCINTF SCMonthToStr( SCCHARP, CONST SCINT );
SCINTF SCPackedDateTo3( SCINTP, SCINTP, SCINTP, CONST SCUSHORT );
SCINTF SCPackedTimeTo3( SCINTP, SCINTP, SCINTP, CONST SCUSHORT );
SCINTF SCReAllocateMemory( SCVOIDPP, CONST ULEN );
SCINTF SCSecondsBetweenStr( SCLONGP, CONST SCCHARP, CONST SCINT, CONST SCCHARP, CONST SCINT );
SCINTF SCSetDefaultDateStyle( CONST SCINT );
SCINTF SCSetErrorCode( CONST SCINT );
SCINTF SCSetLockCount( CONST SCINT );
SCINTF SCSetLockRetryCount( CONST SCINT );
SCINTF SCStrDateTo3( SCINTP, SCINTP, SCINTP, CONST SCCHARP, CONST SCINT );
SCINTF SCStrDateToDayOfWeek( SCCHARP, CONST SCCHARP, CONST SCINT );
SCINTF SCStrDateToIntDayWeek( SCINTP, CONST SCCHARP, CONST SCINT );
SCINTF SCStrDateToLong( SCLONGP, CONST SCCHARP, CONST SCINT );
SCINTF SCStrDateToMonth( SCCHARP, CONST SCCHARP, CONST SCINT );
SCINTF SCStrTimeTo3( SCINTP, SCINTP, SCINTP, CONST SCCHARP, CONST SCINT );
SCVOIDF SCTerminate( SCVOID );
SCINTF SCTime3ToPacked( SCUSHORTP, CONST SCINT, CONST SCINT, CONST SCINT );
SCINTF SCTime3ToStr( SCCHARP, CONST SCINT, CONST SCINT, CONST SCINT, CONST SCINT );

#ifndef __STRCMPI_DEF__
  SCINT SCstricmp( SCCHARP, SCCHARP );
#endif

SCCHARP _SCGetErrorStr( SCINT );
SCUSHORT _SCSwapBytesShort( CONST SCUSHORT );
SCULONG _SCSwapBytesLong( CONST SCULONG );
SCVOID _SCSwapBytesFloat( CONST SCUCHARP, SCUCHARP );
SCVOID _SCSwapBytesDouble( CONST SCUCHARP, SCUCHARP );
SCLONG _SCLongToNative( CONST SCUCHAR, CONST SCLONG );
SCLONG _SCLongToFile( CONST SCUCHAR, CONST SCLONG );

#ifdef __cplusplus
}
#endif

#endif
