/*
** EXAMP096.C
**
** The SoftC Database Library
**
** Copyright (C) 1989, 1997 SoftC, Ltd..  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
short nShort, nKey;
char szKey[8];

DBFIELD aField[] = { { "SIZE", DBSHORTFIELD, 7, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "SIZE", DBSHORTKEY, "SIZE", 7, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   nShort=2000;
   DBPutFieldData( iDBF, 0, &nShort );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBShortToKey( lTag, szKey, nShort );
   DBInsertKey( lTag, szKey, lRecNo );
   nShort=1000;
   DBPutFieldData( iDBF, 0, &nShort );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBShortToKey( lTag, szKey, nShort );
   DBInsertKey( lTag, szKey, lRecNo );
   nShort=3000;
   DBPutFieldData( iDBF, 0, &nShort );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBShortToKey( lTag, szKey, nShort );
   DBInsertKey( lTag, szKey, lRecNo );
   nShort=4000;
   DBPutFieldData( iDBF, 0, &nShort );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBShortToKey( lTag, szKey, nShort );
   DBInsertKey( lTag, szKey, lRecNo );
   DBGoFirstKey( lTag, szKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBKeyToShort( lTag, &nKey, szKey );
      DBGetRecord( iDBF, lRecNo );
      DBGetFieldData( iDBF, 0, &nShort );
      printf( "%ld %d %d\n", lRecNo, nKey, nShort );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }
   DBCloseFile( iDBF );
   DBCloseIndex( iMDX );
   DBTerminate();
   exit( 0 );
}
