/*
** EXAMP094.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
long lLong, lKey;
char szKey[8];

DBFIELD aField[] = { { "SIZE", DBLONGFIELD, 7, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4|DBOPENLAN );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4|DBOPENLAN );
   DBCreateTag( iMDX, "SIZE", DBLONGKEY, "SIZE", 7, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   lLong=2000;
   DBPutFieldData( iDBF, 0, &lLong );
   DBLockHeader( iDBF );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBUnLockHeader( iDBF );
   DBLongToKey( lTag, szKey, lLong );
   DBLockIndex( iMDX );
   DBInsertKey( lTag, szKey, lRecNo );
   DBUnLockIndex( iMDX );
   lLong=1000;
   DBPutFieldData( iDBF, 0, &lLong );
   DBLockHeader( iDBF );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBUnLockHeader( iDBF );
   DBLongToKey( lTag, szKey, lLong );
   DBLockIndex( iMDX );
   DBInsertKey( lTag, szKey, lRecNo );
   DBUnLockIndex( iMDX );
   lLong=3000;
   DBPutFieldData( iDBF, 0, &lLong );
   DBLockHeader( iDBF );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBUnLockHeader( iDBF );
   DBLongToKey( lTag, szKey, lLong );
   DBLockIndex( iMDX );
   DBInsertKey( lTag, szKey, lRecNo );
   DBUnLockIndex( iMDX );
   lLong=4000;
   DBPutFieldData( iDBF, 0, &lLong );
   DBLockHeader( iDBF );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBUnLockHeader( iDBF );
   DBLongToKey( lTag, szKey, lLong );
   DBLockIndex( iMDX );
   DBInsertKey( lTag, szKey, lRecNo );
   DBUnLockIndex( iMDX );
   DBGoFirstKey( lTag, szKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBKeyToLong( lTag, &lKey, szKey );
      DBGetRecord( iDBF, lRecNo );
      DBGetFieldData( iDBF, 0, &lLong );
      printf( "%ld %ld %ld\n", lRecNo, lKey, lLong );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }
   DBCloseFile( iDBF );
   DBCloseIndex( iMDX );
   DBTerminate();
}
