/*
** EXAMP093.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
char szKey[9];
double dKey;

DBFIELD aField[] = { { "DATE", 'D', 8, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "DATE", DBDATEKEY, "DATE", 8, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBPutNamedData( iDBF, "DATE", "01/02/95" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBDateToKey( lTag, ( char* )&dKey, "01/02/95", DBGREGORIAN );
   DBInsertKey( lTag, &dKey, lRecNo );
   DBPutNamedData( iDBF, "DATE", "01/01/95" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBDateToKey( lTag, ( char* )&dKey, "01/01/95", DBGREGORIAN );
   DBInsertKey( lTag, &dKey, lRecNo );
   DBGoFirstKey( lTag, szKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBKeyToDate( lTag, szKey, DBGREGORIAN, szKey );
      printf( "%ld %s\n", lRecNo, szKey );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }
   DBCloseIndex( iMDX );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
