/*
** EXAMP079.C
**
** The SoftC Database Library
**
** Copyright (C) 1989, 1997 SoftC, Ltd..  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
double dFloat;
float fFloat;
char szFloatKey[8];

DBFIELD aField[] = { { "SIZE", 'F', 7, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "SIZE", DBFLOATKEY, "SIZE", 12, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   dFloat=2000;
   DBPutFieldData( iDBF, 0, &dFloat );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBFloatToKey( lTag, szFloatKey, dFloat );
   DBInsertKey( lTag, szFloatKey, lRecNo );
   dFloat=1000;
   DBPutFieldData( iDBF, 0, &dFloat );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBFloatToKey( lTag, szFloatKey, dFloat );
   DBInsertKey( lTag, szFloatKey, lRecNo );
   dFloat=3000;
   DBPutFieldData( iDBF, 0, &dFloat );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBFloatToKey( lTag, szFloatKey, dFloat );
   DBInsertKey( lTag, szFloatKey, lRecNo );
   dFloat=4000;
   DBPutFieldData( iDBF, 0, &dFloat );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBFloatToKey( lTag, szFloatKey, dFloat );
   DBInsertKey( lTag, szFloatKey, lRecNo );
   DBGoFirstKey( lTag, szFloatKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBKeyToFloat( lTag, &fFloat, szFloatKey );
      printf( "%ld %7.0f\n", lRecNo, fFloat );
      DBGoNextKey( lTag, szFloatKey, &lRecNo );
   }
   DBCloseFile( iDBF );
   DBCloseIndex( iMDX );
   DBTerminate();
   exit( 0 );
}
