/*
** EXAMP077.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dblib.h"

int iDBF, iMDX, iNumTags;
long lRecNo, lTag;
char szKey[13];
DBTAGINFO *pTagInfo;

DBFIELD aField[] = { { "FILENAME", 'C', 12, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "FILENAME", DBCHARACTERKEY|DBUNIQUEINDEX, "FILENAME", 12, 0, NULL );
   DBGetAllTagInfo( iMDX, &iNumTags, &pTagInfo );
   printf( "Tag name is %s\n", pTagInfo[ iNumTags-1 ].tname );
   printf( "Key length is %d\n", pTagInfo[ iNumTags-1 ].keylen );
   printf( "Key type is %c\n", pTagInfo[ iNumTags-1 ].keytype );
   printf( "Key format is %d\n", pTagInfo[ iNumTags-1 ].keyfmt );
   printf( "Key expression length is %d\n", pTagInfo[ iNumTags-1 ].exprlen );
   printf( "Key expression is %s", pTagInfo[ iNumTags-1 ].expr );
   DBFreeMemory( pTagInfo );
   DBOpenTag( &lTag, iMDX, 1 );
   DBPutFieldData( iDBF, 0, "CONFIG.SYS" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBInsertKey( lTag, "CONFIG.SYS", lRecNo );
   DBPutFieldData( iDBF, 0, "CONFIG.BAK" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBInsertKey( lTag, "CONFIG.BAK", lRecNo );
   DBMarkRecordInActive( iDBF, 2L );
   strcpy( szKey, "CONFIG.BAK" );
   lRecNo=2L;
   DBDeleteKey( lTag, szKey, lRecNo );
   DBCloseIndex( iMDX );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
