/*
** EXAMP076.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
char szDate[9];
double dDateKey;
struct { char szFirst[5];
         char szLast[4];
       } pRecord;

char *aArray[] = { "Mary Jane" };

DBFIELD aFields[] = { { "STRUCTURE", 'C', 9, 0 },
                      { "ARRAY",     'C', 9, 0 },
                      { "DATE",      'D', 8, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 3, aFields, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "DATE", DBDATEKEY, "DATE", 8, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   strcpy( pRecord.szFirst, "John" );
   strcpy( pRecord.szLast, "Doe" );
   DBPutFieldBinary( iDBF, 0, &pRecord );
   DBPutFieldBinary( iDBF, 1, aArray[0] );
   DBPutFieldData( iDBF, 2, "01/01/95" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBDateToKey( lTag, ( char* )&dDateKey, "01/01/95", DBGREGORIAN );
   DBInsertKey( lTag, &dDateKey, lRecNo );
   DBGetRecord( iDBF, 1L );
   DBGetFieldBinary( iDBF, 0, &pRecord );
   DBGetFieldBinary( iDBF, 1, aArray[0] );
   DBGetFieldData( iDBF, 2, szDate );
   printf( "%s %s\n", pRecord.szFirst, pRecord.szLast );
   printf( "%s\n", aArray[0] );
   puts( szDate );
   DBCloseIndex( iMDX );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
