/*
** EXAMP053.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
char szExpression[256];

DBFIELD aField[] = { { "FILENAME", 'C', 12, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4 );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "FILENAME", DBCHARACTERKEY, "FILENAME", 12, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   DBGetIndexKeyExpr( lTag, szExpression );
   printf( "Tag one expression is %s\n", szExpression );
   DBPutNamedData( iDBF, "FILENAME", "AUTOEXEC.BAT" );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   printf( "Record deleted? %s\n",
      DBIsRecordDeleted( iDBF ) ? "YES":"NO" );
   DBMarkRecordInActive( iDBF, lRecNo );
   printf( "Record deleted? %s\n",
      DBIsRecordDeleted( iDBF ) ? "YES":"NO" );
   DBMarkRecordActive( iDBF, lRecNo );
   printf( "Record deleted? %s\n",
      DBIsRecordDeleted( iDBF ) ? "YES":"NO" );
   DBCloseTag(lTag);
   DBCloseIndex( iMDX );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
