/*
** EXAMP033.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd..  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag, lLong, lKey;
char szKey[8];

DBFIELD aField[] = { { "SIZE", DBCOUNTERFIELD, 7, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBCreateIndex( "EXAMPLE.NTX", 1, DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.NTX", DBDBASE4 );
   DBCreateTag( iMDX, "SIZE", DBCOUNTERKEY, "SIZE", 7, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBCounterToKey( lTag, szKey, lRecNo );
   DBInsertKey( lTag, szKey, lRecNo );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBCounterToKey( lTag, szKey, lRecNo );
   DBInsertKey( lTag, szKey, lRecNo );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBCounterToKey( lTag, szKey, lRecNo );
   DBInsertKey( lTag, szKey, lRecNo );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBCounterToKey( lTag, szKey, lRecNo );
   DBInsertKey( lTag, szKey, lRecNo );
   DBGoFirstKey( lTag, szKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBKeyToCounter( lTag, &lKey, szKey );
      DBGetRecord( iDBF, lRecNo );
      DBGetFieldData( iDBF, 0, &lLong );
      printf( "%ld %ld %ld\n", lRecNo, lKey, lLong );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }
   DBCloseFile( iDBF );
   DBCloseIndex( iMDX );
   DBTerminate();
   exit( 0 );
}
