/*
** EXAMP024.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd..  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iMDX;
long lRecNo, lTag;
unsigned short unShort, unKey;
char szKey[8];

DBFIELD aField[] = { { "SIZE", DBBITFIELD, 7, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBDBASE4|DBPRODUCTIONINDEX );
   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );
   DBCreateTag( iMDX, "SIZE", DBBITFIELDKEY, "SIZE", 7, 0, NULL );
   DBOpenTag( &lTag, iMDX, 1 );
   unShort=2;
   DBPutFieldData( iDBF, 0, &unShort );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBBitFieldToKey( lTag, szKey, unShort );
   DBInsertKey( lTag, szKey, lRecNo );
   unShort=1;
   DBPutFieldData( iDBF, 0, &unShort );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBBitFieldToKey( lTag, szKey, unShort );
   DBInsertKey( lTag, szKey, lRecNo );
   unShort=3;
   DBPutFieldData( iDBF, 0, &unShort );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBBitFieldToKey( lTag, szKey, unShort );
   DBInsertKey( lTag, szKey, lRecNo );
   unShort=4;
   DBPutFieldData( iDBF, 0, &unShort );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBBitFieldToKey( lTag, szKey, unShort );
   DBInsertKey( lTag, szKey, lRecNo );
   DBGoFirstKey( lTag, szKey, &lRecNo );
   while( DBGetErrorCode() == DBSUCCESS )
   {
      DBKeyToBitField( lTag, &unKey, szKey );
      DBGetRecord( iDBF, lRecNo );
      DBGetFieldData( iDBF, 0, &unShort );
      printf( "%ld %u %d\n", lRecNo, unKey, unShort );
      DBGoNextKey( lTag, szKey, &lRecNo );
   }
   DBCloseFile( iDBF );
   DBCloseIndex( iMDX );
   DBTerminate();
   exit( 0 );
}
