/*
** L1DEM020.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

void DisplayIndex ( void );

long lTag1, lTag2, lRecNo;
int  iLoop, iDBF, iCDX, iStatus;
char szKey[21], szFName[21], szLName[21];
char *pFNames[] = { "Merc", "Billy", "Tom", "Mark", "Ruby" };
char *pLNames[] = { "Legr", "McDaniel", "Adams", "Nelson", "Crawford" };

DBFIELD Fields[] = { { "FNAME", 'C', 20, 0 },
                     { "LNAME", 'C', 20, 0 } };

void main( void )
{
   DBInitialize( 20,0 );

   DBCreateFile( "EXAMPLE.DBF", 2, Fields, DBFOXPRO2|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBFOXPRO2 );

   DBCreateIndex( "EXAMPLE.CDX", 1, DBFOXPRO2|DBPRODUCTIONINDEX|DBCOMPOUNDINDEX|DBCOMPRESSEDINDEX );
   DBOpenIndex( &iCDX, "EXAMPLE.CDX", DBOPENSTANDARD|DBFOXPRO2 );

   DBCreateTag( iCDX, "FNAME", DBCHARACTERKEY, "FNAME", 20, 0, NULL );
   DBCreateTag( iCDX, "LNAME", DBCHARACTERKEY, "LNAME", 20, 0, NULL );

   DBOpenTag( &lTag1, iCDX, 1 );
   DBSetDefaultKeyType( lTag1, DBCHARACTERKEY );

   DBOpenTag( &lTag2, iCDX, 2 );
   DBSetDefaultKeyType( lTag2, DBCHARACTERKEY );

   for( iLoop = 0; iLoop < 5; iLoop++ )
   {
      printf( "Name added: %s %s\n", pFNames[ iLoop ], pLNames[ iLoop ] );

      DBPutFieldData( iDBF, 0, pFNames[ iLoop ] );
      DBPutFieldData( iDBF, 1, pLNames[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

      DBInsertKey( lTag1, pFNames[ iLoop ], lRecNo );
      DBInsertKey( lTag2, pLNames[ iLoop ], lRecNo );
   }

   DisplayIndex();

   strcpy( szKey, "Merc" );
   DBKeySearch( lTag1, szKey, &lRecNo, DBKEYEQUAL );
   DBDeleteKey( lTag1, szKey, lRecNo );

   strcpy( szKey, "Legr" );
   DBKeySearch( lTag2, szKey, &lRecNo, DBKEYEQUAL );
   DBDeleteKey( lTag2, szKey, lRecNo );

   DBGetRecord( iDBF, lRecNo );
   DBPutFieldData( iDBF, 0, "Marc" );
   DBPutFieldData( iDBF, 1, "Leger" );
   DBPutRecord( iDBF, &lRecNo, DBUPDATERECORD );

   DBInsertKey( lTag1, "Marc", lRecNo );
   DBInsertKey( lTag2, "Leger", lRecNo );

   DisplayIndex();

   DBCloseIndex( iCDX );
   DBCloseFile( iDBF );
   DBTerminate();
}

void DisplayIndex()
{
   puts( "" );

   DBGoFirstKey( lTag2, szKey, &lRecNo );

   while( iStatus == DBSUCCESS )
   {
      DBGetRecord( iDBF, lRecNo );
      DBGetFieldData( iDBF, 0, szFName );
      DBGetFieldData( iDBF, 1, szLName );

      printf( "%s %s\n", szFName, szLName );

      iStatus = DBGoNextKey( lTag2, szKey, &lRecNo );
   }
   iStatus = DBSUCCESS;
}
