/*
** L1DEM013.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

int iDBF, iMDX, iLoop;
long lTag1, lTag2, lRecNo;
double dKey;
char szStartDate[9], szEndDate[9], szKey[9];
char *pStartDate[] = { "04/04/95", "", "03/24/95", "03/01/95" };
char *pEndDate[]  =  { "04/09/95", "02/10/95", "03/29/95", "06/18/95" };

DBFIELD Fields[] = { { "SDATE", 'D', 8, 0 },
                     { "EDATE", 'D', 8, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 2, Fields, DBDBASE4|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );

   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenIndex( &iMDX,"EXAMPLE.MDX", DBOPENSTANDARD|DBDBASE4 );

   DBCreateTag( iMDX, "SDATE", DBDATEKEY|DBDESCENDINDEX, "SDATE", 8, 0, NULL );
   DBCreateTag( iMDX, "EDATE", DBDATEKEY, "EDATE", 8, 0, NULL );

   DBOpenNamedTag( &lTag1, iMDX, "SDATE" );
   DBOpenNamedTag( &lTag2, iMDX, "EDATE" );

   for( iLoop = 0; iLoop < 4; iLoop++ )
   {
      DBPutNamedData( iDBF, "SDATE", pStartDate[ iLoop ] );
      DBPutNamedData( iDBF, "EDATE", pEndDate[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

      DBDateToKey( lTag1, ( char* )&dKey, pStartDate[ iLoop ], DBGREGORIAN );
      DBInsertKey( lTag1, &dKey, lRecNo );

      DBDateToKey( lTag2, ( char* )&dKey, pEndDate[ iLoop ], DBGREGORIAN );
      DBInsertKey( lTag2, &dKey, lRecNo );
   }

   DBGoFirstKey( lTag1, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToDate( lTag1, szStartDate, DBGREGORIAN, szKey );
      printf( "Key: %ld %s\n", lRecNo, szStartDate );
      DBGoNextKey( lTag1, szKey, &lRecNo );
   }

   puts( "" );

   DBGoFirstKey( lTag2, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToDate( lTag2, szEndDate, DBGREGORIAN, szKey );
      printf( "Key: %ld %s\n", lRecNo, szEndDate );
      DBGoNextKey( lTag2, szKey, &lRecNo );
   }

   DBDateToKey( lTag1, ( char* )&dKey, "", DBGREGORIAN );
   DBKeySearch( lTag1, &dKey, &lRecNo, DBKEYEQUAL );

   DBGetRecord( iDBF, lRecNo );
   DBGetFieldData( iDBF, 0, szStartDate );
   DBGetFieldData( iDBF, 1, szEndDate );

   printf( "\nStart date: %s\nEnd date  : %s\n\n", szStartDate, szEndDate );

   DBDeleteKey( lTag1, &dKey, lRecNo );

   DBPutFieldData( iDBF, 0, "02/05/95" );
   DBPutRecord( iDBF, &lRecNo, DBUPDATERECORD );

   DBDateToKey( lTag1, ( char* )&dKey, "02/05/95", DBGREGORIAN );
   DBInsertKey( lTag1, &dKey, lRecNo );

   DBGoFirstKey( lTag1, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToDate( lTag1, szStartDate, DBGREGORIAN, szKey );
      printf( "Key: %ld %s\n", lRecNo, szStartDate );
      DBGoNextKey( lTag1, szKey, &lRecNo );
   }

   puts( "" );

   DBGoFirstKey( lTag2, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToDate( lTag2, szEndDate, DBGREGORIAN, szKey );
      printf( "Key: %ld %s\n", lRecNo, szEndDate );
      DBGoNextKey( lTag2, szKey, &lRecNo );
   }

   DBCloseIndex( iMDX );
   DBCloseFile( iDBF );
   DBTerminate();
}

