/*
** L1DEM011.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

int iDBF, iMDX, iLoop;
long lRecNo, lTag1, lTag2;

char *pFName[] = { "Marc", "Robert", "Ashley", "Amelia", "Shellye" };
char *pLName[] = { "Leger", "Schoolcraft", "Thomas", "Davis", "Brooks" };

char szKey[26], szFName[26], szLName[26];

DBFIELD Fields[] = { { "FNAME", 'C', 25, 0 },
                     { "LNAME", 'C', 25, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 2, Fields, DBDBASE4|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4 );

   DBCreateIndex( "EXAMPLE.MDX", 1, DBDBASE4 );
   DBOpenIndex( &iMDX, "EXAMPLE.MDX", DBDBASE4 );

   for( iLoop = 0; iLoop < 5; iLoop++ )
   {
      DBPutNamedData( iDBF, "FNAME", pFName[ iLoop ] );
      DBPutNamedData( iDBF, "LNAME", pLName[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   }

   DBBuildTag( iDBF, iMDX, "FNAME", DBCHARACTERKEY, "FNAME", 25, 0, NULL, NULL, 0 );
   DBBuildTag( iDBF, iMDX, "LNAME", DBCHARACTERKEY, "LNAME", 25, 0, NULL, NULL, 0 );

   DBOpenNamedTag( &lTag1, iMDX, "FNAME" );
   DBOpenNamedTag( &lTag2, iMDX, "LNAME" );

   strcpy( szKey, "Schoolcraft" );
   DBKeySearch( lTag2, szKey, &lRecNo, DBKEYEQUAL );

   DBGetRecord( iDBF, lRecNo );
   DBGetFieldData( iDBF, 0, szFName );
   DBGetFieldData( iDBF, 1, szLName );

   printf("Record found is:\n%s\n%s\n\n", szFName, szLName );

   DBPutFieldData( iDBF, 0, "Kerry" );
   DBPutFieldData( iDBF, 1, "Adams" );
   DBPutRecord( iDBF, &lRecNo, DBUPDATERECORD );

   strcpy( szKey, "Robert" );
   DBDeleteKey( lTag1, szKey, lRecNo );
   strcpy( szKey, "Schoolcraft" );
   DBDeleteKey( lTag2, szKey, lRecNo );

   DBInsertKey( lTag1, "Kerry", lRecNo );
   DBInsertKey( lTag2, "Adams", lRecNo );

   DBGoFirstKey( lTag1, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      printf( "%ld %s\n", lRecNo, szKey );
      DBGoNextKey( lTag1, szKey, &lRecNo );
   }

   puts( "" );

   DBGoFirstKey( lTag2, szKey, &lRecNo );

   while (DBGetErrorCode() != DBNOMOREKEYS )
   {
      printf( "%ld %s\n", lRecNo, szKey );
      DBGoNextKey( lTag2, szKey, &lRecNo );
   }

   DBCloseFile( iDBF );
   DBCloseIndex( iMDX );
   DBTerminate();
}

