/*
** L1DEM010.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

int iDBF1, iDBF2, iLoop;
long lRecNo1, lRecNo2;
char *pNames[] = { "Marc", "Billy", "Lucy", "Ruby" };
char szName[11];
DBRECINFO pRecInfo;
DBFIELD Field[] = { { "NAME", 'C', 10, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE1.DBF", 1, Field, DBDBASE3 );
   DBCreateFile( "EXAMPLE2.DBF", 1, Field, DBDBASE3 );

   DBOpenFile( &iDBF1, "EXAMPLE1.DBF", DBDBASE3 );
   DBOpenFile( &iDBF2, "EXAMPLE2.DBF", DBDBASE3 );

   for( iLoop = 0; iLoop < 2; iLoop++ )
   {
      DBPutFieldData( iDBF1, 0, pNames[ iLoop ] );
      DBPutRecord( iDBF1, &lRecNo1, DBAPPENDRECORD );
   }

   for( iLoop = 2; iLoop < 4; iLoop++ )
   {
      DBPutFieldData( iDBF2, 0, pNames[ iLoop ] );
      DBPutRecord( iDBF2, &lRecNo1, DBAPPENDRECORD );
   }

   DBGetRecordInfo( iDBF1, &pRecInfo );
   DBSetBufferAddress( iDBF2, pRecInfo.bfr );

   for( lRecNo1 = 1; lRecNo1 < 3; lRecNo1++ )
   {
      DBGetRecord( iDBF1, lRecNo1 );
      DBPutRecord( iDBF2, &lRecNo2, DBAPPENDRECORD );
   }

   DBGetRecordCount( iDBF2, &lRecNo2 );
   for (lRecNo1 = 1; lRecNo1 <= lRecNo2; lRecNo1++ )
   {
      DBGetRecord( iDBF2, lRecNo1 );
      DBGetNamedStr( iDBF2, "name", szName );
      printf("%ld %s\n", lRecNo1, szName );
   }

   DBCloseFile( iDBF1 );
   DBCloseFile( iDBF2 );
   DBTerminate();
}
