/*
** L1DEM002.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

long lRecNo, lNTX;
int iLoop, iDBF, iNTX;
char szKey[3];
char *pAlphabet[] = { "AA","BB","CC","DD","EE","FF","GG","HH","II","JJ","KK",
                      "LL","MM","NN","OO","PP","QQ","RR","SS","TT","UU","VV",
                      "WW","XX","YY","ZZ" };

DBFIELD Field[] = { { "LETTER", 'C', 2, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 1, Field, DBCLIPPER5 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBCLIPPER5 );

   DBCreateIndex( "EXAMPLE.NTX", 1, DBCLIPPER5 );
   DBOpenIndex( &iNTX, "EXAMPLE.NTX", DBOPENSTANDARD|DBCLIPPER5 );
   DBCreateTag( iNTX, "EXAMPLE", DBCHARACTERKEY, "LETTER", 2, 0, NULL );
   DBOpenTag( &lNTX, iNTX, 0);

   for( iLoop = 0; iLoop < 26; iLoop++ )
   {
      DBPutFieldData( iDBF, 0, pAlphabet[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

      DBInsertKey( lNTX, pAlphabet[ iLoop ], lRecNo );
   }

   strcpy( szKey, "MZ" );
   DBKeySearch( lNTX, szKey, &lRecNo, DBKEYEQUALORGREATER );
   printf( "Search key  : MZ\n" );
   printf( "Method      : DBKEYEQUALORGREATER\n" );
   printf( "Key returned: %ld %2s\n", lRecNo, szKey );
   printf( "DBerrmsg    : %s\n", DBGetErrorStr() );

   strcpy( szKey,"AA" );
   DBKeySearch( lNTX, szKey, &lRecNo, DBKEYLESS );
   printf( "\n\nSearch key  : AA\n" );
   printf( "Method      : DBKEYLESS\n" );
   printf( "Key returned: %ld %2s\n", lRecNo, szKey );
   printf( "DBerrmsg    : %s\n", DBGetErrorStr() );

   strcpy( szKey,"MM" );
   DBKeySearch( lNTX, szKey, &lRecNo, DBKEYGREATER );
   printf( "\n\nSearch key  : MM\n" );
   printf( "Method      : DBKEYGREATER\n" );
   printf( "Key returned: %ld %2s\n", lRecNo, szKey );
   printf( "DBerrmsg    : %s\n", DBGetErrorStr() );

   strcpy( szKey,"OO" );
   lRecNo = 15L;
   DBKeySearch( lNTX, szKey, &lRecNo, DBEXACT );
   printf( "\n\nSearch key  : OO\n" );
   printf( "Method      : DBEXACT\n" );
   printf( "Key returned: %ld %2s\n", lRecNo, szKey );
   printf( "DBerrmsg    : %s\n", DBGetErrorStr() );

   DBCloseFile( iDBF );
   DBCloseIndex( iNTX );
   DBTerminate();
}
