/*
** EXAMP026.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF;
long lRecNo, lMemoRec=1L, lField5;
char szField1[11], szField2[11], cField4, cLogical;
double dFloat=12.34, dNumeric=56.78, dField3, dField6;

DBFIELD aFields[] = { { "CHARACTER", 'C', 10, 0 },
                      { "DATE",      'D',  8, 0 },
                      { "FLOAT",     'F',  5, 2 },
                      { "LOGICAL",   'L',  1, 0 },
                      { "MEMO",      'M', 10, 0 },
                      { "NUMERIC",   'N',  5, 2 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 6, aFields, DBDBASE4 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBDBASE4|DBOPENLAN );
   DBPutFieldData( iDBF, 0, "CHARACTER" );
   DBPutFieldData( iDBF, 1, "01/01/95" );
   DBPutFieldData( iDBF, 2, &dFloat );
   cLogical = 'F';
   DBPutFieldData( iDBF, 3, &cLogical );
   DBPutFieldData( iDBF, 4, &lMemoRec );
   DBPutFieldData( iDBF, 5, &dNumeric );
   DBLockHeader( iDBF );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBUnLockHeader( iDBF );
   DBGetRecord( iDBF, 1L );
   DBGetFieldData( iDBF, 0, szField1 );
   DBGetFieldData( iDBF, 1, szField2 );
   DBGetFieldData( iDBF, 2, &dField3 );
   DBGetFieldData( iDBF, 3, &cField4 );
   DBGetFieldData( iDBF, 4, &lField5 );
   DBGetFieldData( iDBF, 5, &dField6 );
   printf( "Character %s\nDate %s\nFloat %5.2f\nLogical %s\nMemo %ld\n"
         "Numeric %5.2f", szField1, szField2, dField3, cField4 ? "T":"F",
         lField5, dField6 );
   DBLockFile( iDBF );
   DBPackFile( &iDBF, NULL, 0 );
   DBUnLockAll( iDBF );
   DBCloseFile( iDBF );
   DBTerminate();
   exit( 0 );
}
