/*
** L1DEM016.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

int iDBF, iCDX, iLoop;
long lTag1, lTag2, lTag3, lTag4, lRecNo;
double dStockNo, dPriceChngs, dVolume;
char szKey[11];
char *pDescrip[]={ "Truck", "Car", "Boat", "Bicycle", "Skateboard" };

DBFIELD Fields[] = { { "STOCKNO",    'N',  5, 0 },
                     { "PRICECHNGS", 'N',  8, 2 },
                     { "VOLUME",     'N',  5, 0 },
                     { "DESCRIP",    'C', 10, 0 } };
void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 4, Fields, DBFOXPRO2|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBFOXPRO2 );

   DBCreateIndex( "EXAMPLE.CDX", 1, DBFOXPRO2|DBCOMPOUNDINDEX|DBCOMPRESSEDINDEX|DBPRODUCTIONINDEX );
   DBOpenIndex( &iCDX, "EXAMPLE.CDX", DBFOXPRO2 );

   DBCreateTag( iCDX, "STOCKNO", DBNUMERICKEY|DBUNIQUEINDEX, "stockno", 8, 0, NULL );
   DBCreateTag( iCDX, "PRICECHNGS", DBNUMERICKEY, "pricechngs", 8, 0, NULL );
   DBCreateTag( iCDX, "VOLUME", DBNUMERICKEY, "volume", 8, 0, NULL );
   DBCreateTag( iCDX, "DESCRIP", DBCHARACTERKEY, "descrip", 10, 0, NULL );

   DBOpenNamedTag( &lTag1, iCDX, "STOCKNO" );
   DBSetDefaultKeyType( lTag1, DBNUMERICKEY );

   DBOpenNamedTag( &lTag2, iCDX, "PRICECHNGS" );
   DBSetDefaultKeyType( lTag2, DBNUMERICKEY );

   DBOpenNamedTag( &lTag3, iCDX, "VOLUME" );
   DBSetDefaultKeyType( lTag3, DBNUMERICKEY );

   DBOpenNamedTag( &lTag4, iCDX, "DESCRIP" );
   DBSetDefaultKeyType( lTag4, DBCHARACTERKEY );

   dStockNo    = 1254;
   dPriceChngs = 5.24;
   dVolume     = 100;

   for( iLoop = 0; iLoop < 5; iLoop++ )
   {
      DBPutNamedData( iDBF, "STOCKNO", &dStockNo );
      DBPutNamedData( iDBF, "PRICECHNGS", &dPriceChngs );
      DBPutNamedData( iDBF, "VOLUME", &dVolume );
      DBPutNamedData( iDBF, "DESCRIP", pDescrip[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

      DBNumericToKey( lTag1, szKey, dStockNo );
      DBInsertKey( lTag1, szKey, lRecNo );

      DBNumericToKey( lTag2, szKey, dPriceChngs );
      DBInsertKey( lTag2, szKey, lRecNo );

      DBNumericToKey( lTag3, szKey, dVolume );
      DBInsertKey( lTag3, szKey, lRecNo );

      DBInsertKey( lTag4, pDescrip[ iLoop ], lRecNo );

      ++dStockNo;
      ++dPriceChngs;
      ++dVolume;
   }

   DBGoFirstKey( lTag1, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToNumeric( lTag1, &dStockNo, szKey );
      printf( "Key: %ld %5.0lf\n", lRecNo, dStockNo );
      DBGoNextKey( lTag1, szKey, &lRecNo );
   }

   puts( "" );

   DBGoFirstKey( lTag2, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToNumeric( lTag2, &dPriceChngs, szKey );
      printf( "Key: %ld %5.2lf\n", lRecNo, dPriceChngs );
      DBGoNextKey( lTag2, szKey, &lRecNo );
   }

   puts( "" );

   DBGoFirstKey( lTag3, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToNumeric( lTag3, &dVolume, szKey );
      printf("Key: %ld %5.0lf\n", lRecNo, dVolume );
      DBGoNextKey( lTag3, szKey, &lRecNo );
   }

   puts( "" );

   DBGoFirstKey( lTag4, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      printf( "Key: %ld %s\n", lRecNo, szKey );
      DBGoNextKey( lTag4, szKey, &lRecNo );
   }

   strcpy( szKey, "Skateboard" );
   DBKeySearch( lTag4, szKey, &lRecNo, DBKEYEQUAL );

   DBGetRecord( iDBF, lRecNo );
   DBGetNamedData( iDBF, "STOCKNO", &dStockNo );
   DBGetNamedData( iDBF, "PRICECHNGS", &dPriceChngs );
   DBGetNamedData( iDBF, "VOLUME", &dVolume );

   DBMarkRecordInActive( iDBF, lRecNo );

   DBDeleteKey( lTag4, szKey, lRecNo );

   DBNumericToKey( lTag1, szKey, dStockNo );
   DBKeySearch( lTag1, szKey, &lRecNo, DBKEYEQUAL );
   DBDeleteKey( lTag1, szKey, lRecNo );

   DBNumericToKey( lTag2, szKey, dPriceChngs );
   DBKeySearch( lTag2, szKey, &lRecNo, DBEXACT );
   DBDeleteKey( lTag2, szKey, lRecNo );

   DBNumericToKey( lTag3, szKey, dVolume );
   DBKeySearch( lTag3, szKey, &lRecNo, DBEXACT );
   DBDeleteKey( lTag3, szKey, lRecNo );

   printf("\n\n");

   DBGoFirstKey( lTag1, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToNumeric( lTag1, &dStockNo, szKey );
      printf( "Key: %ld %5.0lf\n", lRecNo, dStockNo );
      DBGoNextKey( lTag1, szKey, &lRecNo );
   }

   puts( "" );

   DBGoFirstKey( lTag2, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToNumeric( lTag2, &dPriceChngs, szKey );
      printf( "Key: %ld %5.2lf\n", lRecNo, dPriceChngs );
      DBGoNextKey( lTag2, szKey, &lRecNo );
   }

   puts( "" );

   DBGoFirstKey( lTag3, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      DBKeyToNumeric( lTag3, &dVolume, szKey );
      printf("Key: %ld %5.0lf\n", lRecNo, dVolume );
      DBGoNextKey( lTag3, szKey, &lRecNo );
   }

   puts( "" );

   DBGoFirstKey( lTag4, szKey, &lRecNo );

   while( DBGetErrorCode() != DBNOMOREKEYS )
   {
      printf( "Key: %ld %s\n", lRecNo, szKey );
      DBGoNextKey( lTag4, szKey, &lRecNo );
   }

   DBCloseIndex( iCDX );
   DBCloseFile( iDBF );
   DBTerminate();
}

