/*
** EXAMP108.C
**
** The SoftC Database Library
**
** Copyright (C) 1994, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include <stdio.h>
#include <stdlib.h>

#include "dblib.h"

int iDBF, iFPT, iMemoType;
long lRecNo, lMemoLength;
char szMemo[11];

DBFIELD aField[] = { { "MEMO", 'M', 10, 0 } };

void main()
{
   DBInitialize( 20, 0 );
   DBCreateFile( "EXAMPLE.DBF", 1, aField, DBFOXPRO2 );
   DBCreateMemo( "EXAMPLE.FPT", 1, DBFOXPRO2 );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBFOXPRO2 );
   DBOpenMemo( &iFPT, "EXAMPLE.FPT", DBFOXPRO2 );
   DBPutMemoRecord( iFPT, &lRecNo, "Memo text.", 10, 10, DBAPPENDRECORD );
   DBGetMemoType( iFPT, 1L, &lMemoLength, &iMemoType );
   if( iMemoType == DBTEXTDATA )
      printf( "Memo type is text.\n" );
   else
      printf( "Memo type is binary.\n" );
   DBPutFieldData( iDBF, 0, &lRecNo );
   DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );
   DBGetRecord( iDBF, 1L );
   DBGetFieldData( iDBF, 0, &lRecNo );
   DBGetMemoToBuffer( iFPT, lRecNo, szMemo, 10, DBCOMPLETE );
   puts( szMemo );
   DBCloseFile( iDBF );
   DBCloseMemo( iFPT );
   DBTerminate();
   exit( 0 );
}
