/*
** L1DEM017.C
**
** The SoftC Database Library
**
** Copyright (C) 1995, 1997 SoftC, Ltd.  All Rights Reserved.
*/

#include "dblib.h"

long lTag, lRecNo;
int  iLoop, iDBF, iCDX, iStatus;
char szKey[3];
char *pAlphabet[] = { "AA","BB","CC","DD","EE","FF","GG","HH","II","JJ","KK",
                      "LL","MM","NN","OO","PP","QQ","RR","SS","TT","UU","VV",
                      "WW","XX","YY","ZZ" };

DBFIELD Field[] = { { "LETTER", 'C', 2, 0 } };

void main( void )
{
   DBInitialize( 20, 0 );

   DBCreateFile( "EXAMPLE.DBF", 1, Field, DBFOXPRO2|DBPRODUCTIONINDEX );
   DBOpenFile( &iDBF, "EXAMPLE.DBF", DBFOXPRO2 );

   DBCreateIndex( "EXAMPLE.CDX", 1, DBFOXPRO2|DBPRODUCTIONINDEX|DBCOMPOUNDINDEX|DBCOMPRESSEDINDEX );
   DBOpenIndex( &iCDX, "EXAMPLE.CDX", DBOPENSTANDARD|DBFOXPRO2 );

   DBCreateTag( iCDX, "LETTER", DBCHARACTERKEY, "LETTER", 2, 0, NULL );
   DBOpenTag( &lTag, iCDX, 1 );
   DBSetDefaultKeyType( lTag, DBCHARACTERKEY );

   for( iLoop = 0; iLoop < 26; iLoop++ )
   {
      DBPutFieldData( iDBF, 0, pAlphabet[ iLoop ] );
      DBPutRecord( iDBF, &lRecNo, DBAPPENDRECORD );

      DBInsertKey( lTag, pAlphabet[ iLoop ], lRecNo );
   }

   strcpy( szKey,"AB" );
   iStatus = DBKeySearch( lTag, szKey, &lRecNo, DBKEYLESS );
   printf( "\n\nSearch key  : AB\n" );
   printf( "Method      : DBKEYLESS\n" );
   printf( "Key returned: %ld %2s\n", lRecNo, szKey );
   printf( "Status      : %d\n", iStatus );

   strcpy( szKey,"MN" );
   iStatus = DBKeySearch( lTag, szKey, &lRecNo, DBKEYLESS );
   printf( "\n\nSearch key  : MN\n" );
   printf( "Method      : DBKEYLESS\n" );
   printf( "Key returned: %ld %2s\n", lRecNo, szKey );
   printf( "Status      : %d\n", iStatus );

   DBCloseFile( iDBF );
   DBCloseIndex( iCDX );
   DBTerminate();
}
