/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "log.h"
#include "utils.h"

#ifndef PB_SDK
	#include <time.h>
	#include <stdarg.h>
#else
	#include "pblibc.h"
#endif

const char zLog::m_LevelChars[2][4] =
{	// normal, mesg, error, fatal
	{'+', '-', '?', '!'},  // intermail
	{'#', ':', '*', '!'}   // binkley
};

zLog::zLog(const char *fileName, log_type logType):
	m_FileName(newStr(fileName)),
	m_LogType(logType),
	m_PID(0),
	m_FileOpen(False)
{
	Open();
}

zLog::~zLog()
{
	if( m_FileName ) delete m_FileName;
	if( m_PID ) delete m_PID;
	if( m_FileOpen ) Close();
}
void
zLog::Open()
{
	if( !m_FileOpen ){
		m_fp = fopen(m_FileName, "a+t");
		if( m_fp ) m_FileOpen = True;
	}
}

void
zLog::Close()
{
	if( m_FileOpen ){
		fclose(m_fp);
		m_FileOpen = False;
	}
}

void
zLog::SetPID(const char *pid)
{
	if( m_PID ) delete m_PID;
	m_PID = newStr(pid);
	if( m_FileOpen && m_PID ){
		if( m_LogType == proboard ) Write(normal, "---------- %s", m_PID);
		else{
			char   bufdate[31];
			time_t timer = time(NULL);
			strftime(bufdate, 30, "%a %d %B %y", localtime(&timer));
			fprintf(m_fp, "----------  %s, %s\n", bufdate, m_PID);
		}
	}
}

void
zLog::Write(log_level logLevel, const char *format, ...)
{
	char       datebuf[20];
	struct tm *tmp;
	va_list    varg;

	if( m_FileOpen && format ){

		time_t timer = time(NULL);
		tmp = localtime(&timer);
		va_start(varg, format);

		if( m_LogType == proboard ){  // this does not support levels
			strftime(datebuf, 20, "%d-%b-%y %H:%M:%S ", tmp);
			fputs(datebuf, m_fp);
		}
		else{
			char levelChar = m_LevelChars[m_LogType][logLevel];
			strftime(datebuf, 20, "%H:%M:%S", tmp);
			fprintf(m_fp, "%c %s  ", levelChar, datebuf);
		}
		vfprintf(m_fp, format, varg);
		fputs("\n", m_fp);
		va_end(varg);
	}
}
