/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "_termctl.h"
#include "stdmac.h"

#ifndef PB_SDK
	#include <string.h>
	#include <stdio.h>
#else
	#include "pblibc.h"
#endif

/*
 * a n s i   t e r m i n a l   i m p l e m e n t a t i o n
 * 
 * this is the implementation of the ansi ctrl sequence class
*/
static const int    pc2ans[8]   = { 0, 4, 2, 6, 1, 5, 3, 7 };
static char         ansiBuf[20] = "\033[";
static char * const ansiSeq     = &ansiBuf[2];

ansi_ctrl::ansi_ctrl()
{
}

void
ansi_ctrl::set_fg(int fore)
{
	term_ctrl::set_fg(fore);
	*ansiSeq = EOS;
	if( fore & 0x08 ) strcat(ansiBuf, "1;");
	sprintf(ansiBuf+strlen(ansiBuf), "%dm", pc2ans[fore & 0x07] + 30);
	put(ansiBuf, strlen(ansiBuf));
}

void
ansi_ctrl::set_bg(int back)
{
	term_ctrl::set_bg(back);
	*ansiSeq = EOS;
	if( back & 0x08 ) strcat(ansiBuf, "5;");
	sprintf(ansiBuf+strlen(ansiBuf), "%dm", pc2ans[back & 0x07] + 40);
	put(ansiBuf, strlen(ansiBuf));
}

void
ansi_ctrl::set_color(int attrib)
{
	term_ctrl::set_color(attrib);
	*ansiSeq = EOS;
	if( get_fg() & 0x08 ) strcat(ansiBuf, "1;");
	if( get_bg() & 0x08 ) strcat(ansiBuf, "5;");
	sprintf(ansiBuf + strlen(ansiBuf), "%d;%dm",
		pc2ans[get_fg() & 0x07] + 30,
		pc2ans[get_bg() & 0x07] + 40);
	put(ansiBuf, strlen(ansiBuf));
}

void
ansi_ctrl::clr_scr()
{
	term_ctrl::clr_scr();
	put("\033[2J", 4);
}

void
ansi_ctrl::clr_eol()
{
	term_ctrl::clr_eol();
	put("\033[K", 3);
}

void
ansi_ctrl::cursor_xy(int x, int y)
{
	term_ctrl::cursor_xy(x, y);
	sprintf(ansiSeq, "%d;%dH", y, x);
	put(ansiBuf, strlen(ansiBuf));
}

void
ansi_ctrl::cursor_up(int rows)
{
	if( 1 == rows ) put("\033[A", 3);
	else
	{
		sprintf(ansiSeq, "%dA", rows);
		put(ansiBuf, strlen(ansiBuf));
	}
	term_ctrl::cursor_up(rows);
}

void
ansi_ctrl::cursor_down(int rows)
{
	if( 1 == rows ) put("\033[B", 3);
	else
	{
		sprintf(ansiSeq, "%dB", rows);
		put(ansiBuf, strlen(ansiBuf));
	}
	term_ctrl::cursor_down(rows);
}

void
ansi_ctrl::cursor_left(int columns)
{
	if( 1 == columns ) put("\033[D", 3);
	else
	{
		sprintf(ansiSeq, "%dD", columns);
		put(ansiBuf, strlen(ansiBuf));
	}
	term_ctrl::cursor_left(columns);
}

void
ansi_ctrl::cursor_right(int columns)
{
	if( 1 == columns ) put("\033[C", 3);
	else
	{
		sprintf(ansiSeq, "%dC", columns);
		put(ansiBuf, strlen(ansiBuf));
	}
	term_ctrl::cursor_right(columns);
}

