/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "_termint.h"
#include "_termctl.h"

/* t h e   a v a t a r   i n t e r p r e t e r   i m p l e m e n t a t i o n
 * 
 * this implements the basic avatar/0+ only. none of the advanced scrolling
 * and negotiating functions are available (they are not common anyway :-)
*/
Boolean
avatar_interp::init( uchar aSOS )
{
	Boolean retval = False;

	switch( aSOS )
	{
		case 0x0c:
			/* this is handled immediately here! */
			/* clear the screen in default color */
			m_ctrl->set_color(3);
			m_ctrl->clr_scr();
			m_eos  = True;
			 /* fall-through to next case */
		case 0x16:
			/* fall-through to next case */
		case 0x19:
			term_interp::init(aSOS);
			retval = True;
			break;
	}

	return retval;
}

void
avatar_interp::handle( uchar aChar )
{
	if( 1 == m_buff->getCount() && 0x16 == m_buff->bp()[0] )
	{
		switch( aChar )
		{
			// these two are special cases - there's more data to come
			case 1 : // fall-through to the next case (^V^A)
			case 8 :
				m_buff->put(aChar); // ^V^H, save character
				return;  // and return now (prevent resetting the interpreter)

			case 2 : m_ctrl->set_bg(m_ctrl->get_bg() | 8); break; // ^V^B
			case 3 : m_ctrl->cursor_up(1);    break;  // ^V^C
			case 4 : m_ctrl->cursor_down(1);  break;  // ^V^D
			case 5 : m_ctrl->cursor_left(1);  break;  // ^V^E
			case 6 : m_ctrl->cursor_right(1); break;  // ^V^F
			case 7 : m_ctrl->clr_eol();       break;  // ^V^G
			default: // what, the heck, is this?
				m_buff->put(aChar);
				m_fail = True;
				return;
		}
		m_eos = True;
		return;
	}
	else if( 2 == m_buff->getCount() )
	{
		// is this a ^V^A[attrib] sequence?
		if( 0x16 == m_buff->bp()[0] && 1 == m_buff->bp()[1] )
		{
			m_ctrl->set_color(aChar & 0x7f);
			m_eos = True;
			return;
		}
		// is this the repeat character command?
		else if( 0x19 == m_buff->bp()[0] )
		{
			for( int i = 0; i < aChar; ++i ) m_ctrl->put(m_buff->bp()[1]);
			m_eos = True;
			return;
		}
		else
		{
			m_buff->put(aChar);
			return;
		}
	}
	else if( 3 == m_buff->getCount() )
	{
		if( 0x16 == m_buff->bp()[0] && 8 == m_buff->bp()[1] )
		{
			m_ctrl->cursor_xy(aChar, m_buff->bp()[2]);
			m_eos = True;
		}
		else
		{
			m_buff->put(aChar);
			m_fail = True;
			return;
		}
	}
	else if( 1 == m_buff->getCount() ) m_buff->put(aChar);
	else
	{ // don't know how to handle this
		m_buff->put(aChar);
		m_fail = True;
	}
}
