/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblibc.h"

/*
 * get disk information. drive is 0 = default, 1 = A, etc. if the drive
 * was invalid, the df_sclus will contain 0xffff. calculations are as
 * follows: free space = df_bsec * df_sclus * df_avail, total space on the
 * disk = df_bsec * df_sclus * df_total
*/
void
getdfree(unsigned char drive, struct dfree *dtable)
{
	union REGS r;

	r.h.ah = 0x36;
	r.h.dl = drive;
	int86(0x21, &r, &r);
	dtable->df_avail = r.x.bx;
	dtable->df_total = r.x.dx;
	dtable->df_bsec  = r.x.cx;
	dtable->df_sclus = r.x.ax;
}
