/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblibc.h"

void interrupt (far *getvect(int intno))(__CPPARGS)
{
	union  REGS  regs;
	struct SREGS sreg;

	regs.h.ah = 0x35;
	regs.h.al = intno;
	int86x(0x21, &regs, &regs, &sreg);
	return (void interrupt (far *)(__CPPARGS))MK_FP(sreg.es, regs.x.bx);
}

void setvect(int intno, void interrupt (far *isr)(__CPPARGS))
{
	union  REGS  regs;
	struct SREGS sreg;

	regs.h.ah = 0x25;
	regs.h.al = intno;
	sreg.ds   = FP_SEG(isr);
	regs.x.dx = FP_OFF(isr);
	int86x(0x21, &regs, &regs, &sreg);
}
