/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblibc.h"

/*
 * binary search routine
*/
void*
bsearch(const void *key, const void *base, size_t nelem,
		size_t width, int (*fcmp)(const void*, const void*) )
{
	size_t i;
	int    j;
	char   *celem, *cbase = (char *)base;

	while( nelem ){
		i = nelem >> 1;                 /* get the middle element       */
		celem = cbase + i * width;      /* calculate offset into array  */
		j = fcmp( key, celem );
		if( 0 == j ) return celem;
		if( 0 > j ) nelem = i;          /* smaller, set new end         */
		else{
			cbase = celem + width;      /* larger, set new beginning to */
			nelem = nelem - i - 1;      /* next element and adjust num  */
		}                               /* of entries to process        */
	}
	return 0;
}

