/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "_termint.h"
#include "_termctl.h"

term_interp::term_interp()
	:m_fail(False)
	,m_eos(True)
	,m_active(False)
	,m_ctrl(0)
	,m_buff(0)
{
}

Boolean
term_interp::init(uchar aSOS )
{
	if( m_buff )
	{
		m_buff->flush();
		m_buff->put(aSOS);
	}
	m_eos  = False;
	m_fail = False;

	return False;
}

void
term_interp::handle(uchar aChar)
{
	if( m_ctrl ) m_ctrl->put(aChar);
}
