/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "str.h"

/*
 * concatenates multiple strings, caller must free the resulting buffer.
 * the last pointer in the list MUST be a NULL pointer for this to work.
*/
	char*
strvcat( char *s, ... )
{
	char *p, *ptr;
	size_t    len;
	va_list   arg;

	if( s ) len = strlen(s);
	else len = 0;

	va_start(arg, s);
	while( NULL != (p = va_arg( arg, char* )) )
		len += strlen(p);
	va_end(arg);

	if( NULL == (ptr = (char *)malloc(len + 1)) ) return NULL;

	if( s ) strcpy(ptr, s);
	else ptr[0] = EOS;

	va_start(arg, p);
	while( NULL != (p = va_arg( arg, char* )) )
		strcat( ptr, p );
	va_end(arg);

	return ptr;
}
