/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "slist.h"

zListIterator::zListIterator(zSingleList &aList, Boolean atStart):
	list(aList)
{
	if( atStart ){
    	focus = list.tail->next;
        cpos = 1L;
	}
    else{
    	focus = list.focus;
        cpos = list.cpos;
	}
}

Boolean
zListIterator::atEnd() const
{
	return (cpos == list.count) ? True : False;
}

ushort
zListIterator::begin()
{
	if( list.count ){
    	focus = list.tail->next;
        cpos = 1L;
        return 1;
	}
    return 0;
}

ushort
zListIterator::end()
{
	if( list.count ){
    	focus = list.tail;
        cpos = list.count;
        return 1;
	}
    return 0;
}

void*
zListIterator::get() const
{
	return (list.count) ? focus->data : 0;
}

ushort
zListIterator::next()
{
	if( list.count && !atEnd() ){
    	focus = focus->next;
        cpos++;
        return 1;
	}
	return 0;
}

ushort
zListIterator::operator+=(ushort nelem)
{
	for( ; nelem; --nelem ){
    	if( atEnd() ) return 0;
        focus = focus->next;
        cpos++;
	}
    return 1;
}

void
zListIterator::sync()
{
	focus = list.focus;
    cpos = list.cpos;
}

ushort
zListIterator::update(void *data)
{
	if( list.count ){
    	focus->data = data;
    	return 1;
	}
    return 0;
}

