/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "pblsdk.h"
#include "proboard.h"
#include "file.h"
#include "pbnames.h"

// read message areas (just like the SDK)
BOOL
ReadMsgArea( int recno, MSGAREA *rec )
{
	FILE *fp = pb_fopen(fnMESSAGES, "rb", PBDIR_SYS);
	if( fp ){
		file_read(fp, rec, (long)recno - 1);
		fclose(fp);
		return TRUE;
	}
	return FALSE;
}

// returns number of message areas
short
NumMsgAreas( void )
{
	long size = file_size(pb_getpath(fnMESSAGES, PBDIR_SYS));
	return (int)(size / sizeof(MESSAGES));
}

// read file areas (just like the SDK)
int
ReadFileArea( int recno, FILECFG *rec )
{
	FILE *fp = pb_fopen(fnFILECFG, "rb", PBDIR_SYS);
	if( fp ){
		file_read(fp, rec, (long)recno - 1);
		fclose(fp);
		return 0;
	}
	return -1;
}

// returns number of file areas
short
NumFileAreas( void )
{
	long size = file_size(pb_getpath(fnFILECFG, PBDIR_SYS));
	return (int)(size / sizeof(FILECFG));
}
