/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "file.h"

#ifndef PB_SDK
	#include <stdlib.h>
	#include <assert.h>
	#include <string.h>
	#include <dir.h>
#else
	#include "stdmac.h"
#endif

/*
 * searches the path variable for a file given in filename. if path is
 * NULL, searches the current directory and then the system PATH statement.
 * you can separate multiple directories in the path string with the MS-DOS
 * style ';' separator. on success, a full filespec is returned, null
 * otherwise.
 *
 * the return string is static and is overwritten with each call.
*/
char*
file_scan( const char *pathSpec, const char *filename )
{
	static char  path[MAXPATH];
		   char  pathList[255];
		   char  name[MAXFILE+MAXEXT];
		   char *ptr;

	/* do some sanity checking and prepend a backslash */
	assert( strlen(filename) < (MAXFILE + MAXEXT) );
	strcat( strcpy(name, "\\"), filename );

	/* check current directory and get PATH (if necessary) */
	if( NULL == pathSpec )
	{
		getcwd(path, MAXDIR);
		strcat( path, name );
		if( file_exist(path) ) return path;
		if( NULL != getenv("PATH") ) strcpy(pathList, getenv("PATH"));
		else strcpy(pathList, "");
	}
	else strcpy(pathList, pathSpec);

	/* we know we have something in our pathList pointer now */
	ptr = strtok( pathList, ";" );
	while( NULL != ptr )
	{
		strcat( strcpy(path, ptr), name );
		if( file_exist(path) ) return path;
		ptr = strtok( NULL, ";" );
	}

	/* nada, zilch, failed miserably, sorry... */
	return NULL;
}

