/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "file.h"
#include "compiler.h"
#include "stdmac.h"

#ifndef PB_SDK
	#ifdef _MSC_VER
	#include <sys/types.h>
	#endif
	#include <sys/stat.h>
	#include <string.h>
	#include <io.h>
#endif

/*
 * removes a single file, used internally by rmfile()
*/
static int
DoRemove( const char *path, zDosFile *file )
{
	char buf[81];

	if( '.' == file->name[0] || file->attrib & FA_DIREC ) return 0;

	strcat( strcpy( buf, path ), file->name );
	chmod( buf, S_IREAD | S_IWRITE );
	return unlink( buf );
}

/*
 * removes a file (wildcards are ok, removes regardless of attributes)
*/
int
file_remove( const char *path )
{
	char     pathspec[MAXPATH];
	zDosFile file;
	int      done;

	strcpy( pathspec, file_dirspec(path) );
	done = FindFirst( (char *)path, FA_ALL, &file );
	while( !done ){
		if( -1 == DoRemove(pathspec, &file) ) return -1;
		done = FindNext( &file );
	}
	return 0;
}
