/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#include "file.h"
#include "compiler.h"

/*
 * returns <0 if file1 is newer than file2, =0 if same date and >0 otherwise
 * if either of the files doesn't exist, the results are undefined
*/
int
file_cmpdate( const char *path1, const char *path2 )
{
	zDosFile n1, n2;

	FindFirst((char*)path1, 0, &n1);
	FindFirst((char*)path2, 0, &n2);

	if( n1.date > n2.date ) return -1;
	if( n1.date == n2.date )
	{
		if( n1.time > n2.time  ) return -1;
		if( n1.time == n2.time ) return 0;
	}
	return 1;
}
