/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_PBNAMES_H
#define INCLUDED_PBNAMES_H

/*
 * p u b l i c l y   a c c e s s i b l e   f i l e   n a m e s
 * 
 * these are the constants used for the file names common to proboard, et.al.
*/
extern char const * const fnAKA;       //.....system aka's (defined with AKA)
extern char const * const fnBINLOG;    //.................binary log (BINLOG)
extern char const * const fnCONFIG;    //.......proboard main config (CONFIG)
extern char const * const fnCOST;      //............netmail cost (free-form)
extern char const * const fnDEFLANG;   //...............default language name
extern char const * const fnDNLOADLOG; //.......download log (formatted text)
extern char const * const fnECHOMAIL;  //..................echomail (unknown)
extern char const * const fnEVENTS;    //...............system events (EVENT)
extern char const * const fnFGROUPS;   //..............file groups (PB_GROUP)
extern char const * const fnFILECFG;   //.........file areas config (FILECFG)
extern char const * const fnFILESIDX;  //............filebase index (FILEIDX)
extern char const * const fnFLAGDESC;  //.........flag description (FLAGDESC)
extern char const * const fnLANGEXT;   //............language files extension
extern char const * const fnLIMITS;    //........limits configuration (LIMIT)
extern char const * const fnMENUEXT;   //................menu files extension
extern char const * const fnMESSAGES;  //......message area config (MESSAGES)
extern char const * const fnMGROUPS;   //....message groups config (PB_GROUP)
extern char const * const fnMODEM;     //.................modem configuration
extern char const * const fnNODEIDX;   //............nodelist index (NODEIDX)
extern char const * const fnONLINE;    //......online user info file (ONLINE)
extern char const * const fnPROTOCOL;  //.....protocol config file (PROTOCOL)
extern char const * const fnPVTFILES;  //......private files config (PVTFILE)
extern char const * const fnTEMPLATE;  //.....validation templates (TEMPLATE)
extern char const * const fnTIMELOG;   //............system timelog (TIMELOG)
extern char const * const fnTOPS;      //..........top user statistics (TOPS)
extern char const * const fnTRASHCAN;  //..........login name trashcan (text)
extern char const * const fnUPLOADLOG; //.........upload log (formatted text)
extern char const * const fnUSERS;     //..........userbase main file (USERS)
extern char const * const fnUSERSIDX;  //......userbase index file (USERSIDX)
extern char const * const fnUSERSPB;   //......pb-specific userbase (USERSPB)
extern char const * const fnUSERSXI;   //........userbase freespace (USERSXI)
extern char const * const fnDOING;     //................fe-line's doing file
extern char const * const fnUSERDOES;  //......eddie van loon's userdoes root

#endif /* INCLUDED_PBNAMES_H */
