/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_EMULATOR_H
#define INCLUDED_EMULATOR_H

#ifdef PB_SDK
	#define proboard_emulator_init()
	#define proboard_emulator_term()
#else
	#include "terminal.h"
	#include "pblsdk.h"

	void proboard_emulator_init(void);
	void proboard_emulator_term(void);

	extern zTerminal * const  Terminal;
	extern zTerminal         *pblib_Terminal;
	extern ansi_interp       *pblib_AnsiHandler;
	extern avatar_interp     *pblib_AvatarHandler;
	extern proboard_interp   *pblib_ProboardHandler;
	extern USER_REC  *       &pblib_CurUser;
	extern LIMIT     *       &pblib_Limits;
	extern CONFIG    *       &pblib_Config;
	extern char               pblib_LoginDate[3];
	extern char               pblib_LoginTime[3];
	extern char               pblib_UserFirstName[30];
	extern char               pblib_SysPath[80];
	extern char               pblib_CurMenu[10];
	extern char               pblib_PrevUser[36];
	extern char               pblib_StartupPath[80];
	extern char               pblib_PageReason[80];
	extern ushort             pblib_PageCount;
	extern short     * const  pblib_NumLimits;
	extern short     * const  pblib_NumUsers;
	extern BOOL      * const  pblib_NetEntered;
	extern BOOL      * const  pblib_EchoEntered;
	extern short     * const  pblib_UserRecNr;
	extern short     * const  pblib_NodeNumber;
	extern long      * const  pblib_BaudRate;
	extern ushort      const  PBVersion;
	extern ushort      const  Beta;

#endif /* PB_SDK not defined */

#endif /* INCLUDED_PBLINIT_H */
