/*
 * This file is part of PB-Lib v3.0 C++ Programming Library
 *
 * Copyright (c) 1995, 1997 by Branislav L. Slantchev
 * A fine product of Silicon Creations, Inc. (gargoyle)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the License which accompanies this
 * software. This library is distributed in the hope that it will
 * be useful, but without any warranty; without even the implied
 * warranty of merchantability or fitness for a particular purpose.
 *
 * You should have received a copy of the License along with this
 * library, in the file LICENSE.DOC; if not, write to the address
 * below to receive a copy via electronic mail.
 *
 * You can reach Branislav L. Slantchev (Silicon Creations, Inc.)
 * at bslantch@cs.angelo.edu. The file SUPPORT.DOC has the current
 * telephone numbers and the postal address for contacts.
*/

#ifndef INCLUDED_KBCODES_H
#define INCLUDED_KBCODES_H

const unsigned short
	//....................................................regular ASCii codes
	kbNoKey          = 0,
	kbEsc            = 0x1b,
	kbEnter          = '\r',
	kbTab            = '\t',
	kbBkSp           = '\b',
	kbNLine          = '\n',
	kbLFeed          = '\n',
	kbFFeed          = '\f',
	//..........................................................function keys
	kbF1             = 0x3B00U,
	kbF2             = 0x3C00U,
	kbF3             = 0x3D00U,
	kbF4             = 0x3E00U,
	kbF5             = 0x3F00U,
	kbF6             = 0x4000U,
	kbF7             = 0x4100U,
	kbF8             = 0x4200U,
	kbF9             = 0x4300U,
	kbF10            = 0x4400U,
	kbF11            = 0x8500U,
	kbF12            = 0x8600U,
	//.....................................................ctrl+function keys
	kbCtlF1          = 0x5E00U,
	kbCtlF2          = 0x5F00U,
	kbCtlF3          = 0x6000U,
	kbCtlF4          = 0x6100U,
	kbCtlF5          = 0x6200U,
	kbCtlF6          = 0x6300U,
	kbCtlF7          = 0x6400U,
	kbCtlF8          = 0x6500U,
	kbCtlF9          = 0x6600U,
	kbCtlF10         = 0x6700U,
	kbCtlF11         = 0x8900U,
	kbCtlF12         = 0x8A00U,
	//....................................................shift+function keys
	kbShF1           = 0x5400U,
	kbShF2           = 0x5500U,
	kbShF3           = 0x5600U,
	kbShF4           = 0x5700U,
	kbShF5           = 0x5800U,
	kbShF6           = 0x5900U,
	kbShF7           = 0x5A00U,
	kbShF8           = 0x5B00U,
	kbShF9           = 0x5C00U,
	kbShF10          = 0x5D00U,
	kbShF11          = 0x8700U,
	kbShF12          = 0x8800U,
	//......................................................alt+function keys
	kbAltF1          = 0x6800U,
	kbAltF2          = 0x6900U,
	kbAltF3          = 0x6A00U,
	kbAltF4          = 0x6B00U,
	kbAltF5          = 0x6C00U,
	kbAltF6          = 0x6D00U,
	kbAltF7          = 0x6E00U,
	kbAltF8          = 0x6F00U,
	kbAltF9          = 0x7000U,
	kbAltF10         = 0x7100U,
	kbAltF11         = 0x8B00U,
	kbAltF12         = 0x8C00U,
	//........................................................cursor pad keys
	kbIns            = 0x5200U,
	kbDel            = 0x5300U,
	kbHome           = 0x4700U,
	kbEnd            = 0x4F00U,
	kbPgUp           = 0x4900U,
	kbPgDn           = 0x5100U,
	kbUp             = 0x4800U,
	kbDown           = 0x5000U,
	kbLeft           = 0x4B00U,
	kbRight          = 0x4D00U,
	//...................................................ctrl+cursor pad keys
	kbCtlEnd         = 0x7500U,
	kbCtlDown        = 0x9100U,
	kbCtlPgDn        = 0x7600U,
	kbCtlLeft        = 0x7300U,
	kbCtlRight       = 0x7400U,
	kbCtlHome        = 0x7700U,
	kbCtlUp          = 0x8D00U,
	kbCtlPgUp        = 0x8400U,
	kbCtlIns         = 0x9200U,
	kbCtlDel         = 0x9300U,
	//...............................................special PC keyboard keys
	kbAltBackSp      = 0x0e00U,
	kbCtlBackSp      = 0x007FU,
	kbShTab          = 0x0f00U,
	kbCtlTab         = 0x9400U,
	kbAltEsc         = 0x0100U,
	//................................................ctrl+normal keys (a..z)
	kbCtlA           = 0x0001U,
	kbCtlB           = 0x0002U,
	kbCtlC           = 0x0003U,
	kbCtlD           = 0x0004U,
	kbCtlE           = 0x0005U,
	kbCtlF           = 0x0006U,
	kbCtlG           = 0x0007U,
	kbCtlH           = 0x0008U,
	kbCtlI           = 0x0009U,
	kbCtlJ           = 0x000AU,
	kbCtlK           = 0x000BU,
	kbCtlL           = 0x000CU,
	kbCtlM           = 0x000DU,
	kbCtlN           = 0x000EU,
	kbCtlO           = 0x000FU,
	kbCtlP           = 0x0010U,
	kbCtlQ           = 0x0011U,
	kbCtlR           = 0x0012U,
	kbCtlS           = 0x0013U,
	kbCtlT           = 0x0014U,
	kbCtlU           = 0x0015U,
	kbCtlV           = 0x0016U,
	kbCtlW           = 0x0017U,
	kbCtlX           = 0x0018U,
	kbCtlY           = 0x0019U,
	kbCtlZ           = 0x001AU,
	//..................................................alt+keys (number row)
	kbAlt1           = 0x7800U,
	kbAlt2           = 0x7900U,
	kbAlt3           = 0x7A00U,
	kbAlt4           = 0x7B00U,
	kbAlt5           = 0x7C00U,
	kbAlt6           = 0x7D00U,
	kbAlt7           = 0x7E00U,
	kbAlt8           = 0x7F00U,
	kbAlt9           = 0x8000U,
	kbAlt0           = 0x8100U,
	kbAltMinus       = 0x8200U,
	kbAltEqu         = 0x8300U,
	//...............................................alt+keys (top alpha row)
	kbAltQ           = 0x1000U,
	kbAltW           = 0x1100U,
	kbAltE           = 0x1200U,
	kbAltR           = 0x1300U,
	kbAltT           = 0x1400U,
	kbAltY           = 0x1500U,
	kbAltU           = 0x1600U,
	kbAltI           = 0x1700U,
	kbAltO           = 0x1800U,
	kbAltP           = 0x1900U,
	kbAltLBrace      = 0x1A00U,
	kbAltRBrace      = 0x1B00U,
	//............................................alt+keys (middle alpha row)
	kbAltA           = 0x1E00U,
	kbAltS           = 0x1F00U,
	kbAltD           = 0x2000U,
	kbAltF           = 0x2100U,
	kbAltG           = 0x2200U,
	kbAltH           = 0x2300U,
	kbAltJ           = 0x2400U,
	kbAltK           = 0x2500U,
	kbAltL           = 0x2600U,
	kbAltColon       = 0x2700U,
	kbAltQuote       = 0x2800U,
	kbAltEnter       = 0x1C00U,
	//.............................................alt+keys (lower alpha row)
	kbAltZ           = 0x2C00U,
	kbAltX           = 0x2D00U,
	kbAltC           = 0x2E00U,
	kbAltV           = 0x2F00U,
	kbAltB           = 0x3000U,
	kbAltN           = 0x3100U,
	kbAltM           = 0x3200U,
	kbAltComma       = 0x3300U,
	kbAltPeriod      = 0x3400U,
	kbAltSlash       = 0x3500U,
	kbAltBSlash      = 0x2B00U,
	kbAltTilde       = 0x2900U;

#endif /* ICNLUDED_KBCODES_H */
