/*****************************************************************************
*                                                                            *
* Copyright (c) 1996-1997 Funduc Software Inc.   All rights reserved.        *
*                                                                            *
* These programs are the sole property of Funduc Software Inc. and contain   *
* proprietary information.  These routines should not by used by anyone      *
* except Funduc Software Inc.'s customers in accoordance with terms of a     *
* license.  To get one, visit us at http://www.funduc.com                    *
* or E-MAIL: sales@funduc.com                                                *
*                                                                            *
*****************************************************************************/
// detesvw.cpp : implementation of the CDetestView class
//

#include "stdafx.h"
#include "detest.h"
#include "decenc.h"

#include "detesdoc.h"
#include "detesvw.h"
#include "dispfile.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDetestView

IMPLEMENT_DYNCREATE(CDetestView, CView)

BEGIN_MESSAGE_MAP(CDetestView, CView)
    //{{AFX_MSG_MAP(CDetestView)
    ON_COMMAND(ID_FILE_DECODE, OnFileDecode)
    ON_COMMAND(ID_FILE_ENCODEUUENCODED, OnFileEncodeuuencoded)
    ON_COMMAND(ID_FILE_DECODE_SHOWFILENAMES, OnFileDecodeShowfilenames)
    ON_COMMAND(ID_FILE_DECODE_OVERWRITEPROMPTONLY, OnFileDecodeOverwritepromptonly)
    ON_COMMAND(ID_FILE_ENCODEBINHEX, OnFileEncodebinhex)
    ON_COMMAND(ID_FILE_ENCODEXXENCODED, OnFileEncodexxencoded)
    ON_COMMAND(ID_UTIL_CONCATENATEFILES, OnUtilConcatenatefiles)
    ON_COMMAND(ID_UTIL_SPLITFILE, OnUtilSplitfile)
    ON_COMMAND(ID_FILE_ENCODEMIMEBASE64, OnFileEncodemimebase64)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDetestView construction/destruction

CDetestView::CDetestView()
{
    // TODO: add construction code here
}

CDetestView::~CDetestView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CDetestView drawing

void CDetestView::OnDraw(CDC* )
{
    CDetestDoc* pDoc = GetDocument();
    ASSERT_VALID(pDoc);

    // TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CDetestView diagnostics

#ifdef _DEBUG
void CDetestView::AssertValid() const
{
    CView::AssertValid();
}

void CDetestView::Dump(CDumpContext& dc) const
{
    CView::Dump(dc);
}

CDetestDoc* CDetestView::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDetestDoc)));
    return (CDetestDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDetestView message handlers

void CDetestView::OnFileDecode()
{          
    int nDecodeType;
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)
    {
        strFileIn = fileOpen.GetPathName();
        nDecodeType = DecodeFile(strFileIn, strFileOut, PROMPT_ALL);
        if (nDecodeType)
        {             
            strFileOut.ReleaseBuffer();
            TRACE1("Decoded file: %s\n", (LPCSTR)strFileOut);
        }
    }
}

void CDetestView::OnFileEncodeuuencoded()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)  // File selected
    {
        strFileOut = strFileIn = fileOpen.GetPathName();
        int nIndex = strFileOut.ReverseFind('.');   // Find and change extension
        if (nIndex != -1)
            strFileOut = strFileOut.Left(nIndex);
        strFileOut += ".UUE";

        GetUniqueFileName(strFileOut.GetBuffer(255));
        strFileOut.ReleaseBuffer();

        if (EncodeFile(strFileIn, strFileOut, UUE_TYPE, FALSE))
        {
            TRACE1("Encoded file: %s\n", (LPCSTR)strFileOut);
        }
    }
}

void CDetestView::OnFileDecodeShowfilenames()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)  // File selected
    {
        strFileIn = fileOpen.GetPathName();
        CDispFilesDlg dlg(strFileIn, this);
        dlg.DoModal();
    }
}

void CDetestView::OnFileDecodeOverwritepromptonly()
{
    int nDecodeType;
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)
    {
        strFileIn = fileOpen.GetPathName();
        nDecodeType = DecodeFile(strFileIn, strFileOut, PROMPT_OVERWRITE);
        if (nDecodeType)
        {             
            strFileOut.ReleaseBuffer();
            TRACE1("Decoded file: %s\n", (LPCSTR)strFileOut);
        }
    }
}

void CDetestView::OnFileEncodebinhex()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)  // File selected
    {
        strFileOut = strFileIn = fileOpen.GetPathName();
        int nIndex = strFileOut.ReverseFind('.');   // Find and change extension
        if (nIndex != -1)
            strFileOut = strFileOut.Left(nIndex);
        strFileOut += ".HQX";
          
        GetUniqueFileName(strFileOut.GetBuffer(255));
        strFileOut.ReleaseBuffer();

        if (EncodeFile(strFileIn, strFileOut, BINHEX_TYPE, FALSE))
        {
            TRACE1("Encoded file: %s\n", (LPCSTR)strFileOut);
        }
    }
}

void CDetestView::OnFileEncodexxencoded()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)  // File selected
    {
        strFileOut = strFileIn = fileOpen.GetPathName();
        int nIndex = strFileOut.ReverseFind('.');   // Find and change extension
        if (nIndex != -1)
            strFileOut = strFileOut.Left(nIndex);
        strFileOut += ".XXE";

        GetUniqueFileName(strFileOut.GetBuffer(255));
        strFileOut.ReleaseBuffer();

        if (EncodeFile(strFileIn, strFileOut, XXE_TYPE, FALSE))
        {
            TRACE1("Encoded file: %s\n", (LPCSTR)strFileOut);
        }
    }
}

void CDetestView::OnUtilConcatenatefiles()
{
    CString strFileIn, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    // Select an encoded file for splitting, then concatenate it using the first
    // one (ie. file1.mim)
    if (fileOpen.DoModal() == IDOK)
    {
        strViewer = strFileIn = fileOpen.GetPathName();
        if (ConcatenateRelated(TRUE, strFileIn.GetBuffer(255)))
        {             
            strFileIn.ReleaseBuffer();
            TRACE1("Concatenated file(s) %s to: %s\n", (LPCSTR)strViewer,
                   (LPCSTR)strFileIn);
        }
        else
            strFileIn.ReleaseBuffer();
    }
}

/* This function will split a file into as many smaller files as necessary
   For example: file.dat of size 100000 will be split into
   file1.dat (size 35000), file2.dat(35000), file3.dat(size 30000)
   if 35000 is used for the lFileSize parameter 
   The name of the last split file is returned in szFileName
*/
void CDetestView::OnUtilSplitfile()
{
    CString strFileIn, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    // Select an encoded file for splitting, then concatenate it using the first
    // one (ie. file1.mim)
    if (fileOpen.DoModal() == IDOK)
    {
        strViewer = strFileIn = fileOpen.GetPathName();
        if (SplitFile(strFileIn.GetBuffer(255), 35000L))
        {             
            strFileIn.ReleaseBuffer();
            TRACE1("Split file(s) %s to: %s\n", (LPCSTR)strViewer,
                   (LPCSTR)strFileIn);
        }
        else
            strFileIn.ReleaseBuffer();
    }
}

void CDetestView::OnFileEncodemimebase64()
{
    CString strFileIn, strFileOut, strViewer;
    CString strExeFilter = "All Files|*.*||";
    CFileDialog fileOpen(TRUE, NULL, strViewer, 
                    OFN_PATHMUSTEXIST | OFN_NOCHANGEDIR | OFN_FILEMUSTEXIST,
                    strExeFilter, this);
    CString strDir = strViewer;
    int nIndex = strDir.ReverseFind('\\');
    if (nIndex != -1)
        strDir = strDir.Left(nIndex + 1);
    fileOpen.m_ofn.lpstrInitialDir = (LPCSTR)strDir;

    if (fileOpen.DoModal() == IDOK)  // File selected
    {   
        // To set your application name in the registered version, use this call
        SetEncodingApplication(AfxGetAppName()); 
        strFileOut = strFileIn = fileOpen.GetPathName();
        int nIndex = strFileOut.ReverseFind('.');   // Find and change extension
        if (nIndex != -1)
            strFileOut = strFileOut.Left(nIndex);
        strFileOut += ".MIM";

        GetUniqueFileName(strFileOut.GetBuffer(255));
        strFileOut.ReleaseBuffer();

        if (EncodeFile(strFileIn, strFileOut, B64_TYPE, FALSE))
        {
            TRACE1("Encoded file: %s\n", (LPCSTR)strFileOut);
        }
    }
}
