/***********************************************************************

                      CSDB Library, Free Evaluation Version 2.1.1 
                                           Release: May 14th 1997 

       Header file of the IBASE class.
       Database class for fixed length records.

                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSIBASE_H
#define __CSIBASE_H

#include <csdir.h>
#include <stdio.h>
#include <string.h>
#include "csdlay.h"


class IBASE: public DLAY
{

protected:

   U16  lenrec;
   U16  recpage;
   U16  rec_foot;
   U16  len_rec_plus_foot;
   S32  NUMREC;
   S32  lrco;
   S32  wrco;
   S32  rrco;
   S32  cur_rec;


protected:

   void check_rec(S32  l);

   S32  r2p(S32  rec)    { return (1+(rec-1)*len_rec_plus_foot); }

   virtual int check_id(U32 id);
   virtual void set_id(void);

   void init_defaults(void);
   void init_vars(void);
   void vars2head(void);
   void head2vars(void);

////////////////////////////////////////////////////////////////////////
////////////////////// PUBLIC FUNCTIONS ////////////////////////////////
////////////////////////////////////////////////////////////////////////

public:
   IBASE(void);
   virtual
  ~IBASE(void);


//////////////////////// Compatibility functions ////////////////////////
   void speed_option_121(void)   { smallest_page(); }
   void smallest_page(void)      {}
   U16  lengthrec(void)          { return length_rec(); }


//////////////////////// Definition //////////////////////////////////////////
   int  define(csCHAR *name,U16  reclen);

//////////////////////// Open & Close ////////////////////////////////////////
   int  open(csCHAR *name,S16 kb=32);
   int  open(void)                 { return already_open(); }
   int  close(void);
   int  save(void);

//////////////////////// Read & Writes records  //////////////////////////////
   void read_rec(  S32  rec, void *d);
   void write_rec( S32  rec, void *d);

//////////////////////// Add Records /////////////////////////////////////////
   S32  append_rec(void *data);
   S32  append_rec(void);

////////////////////////// Inserting ///////////////////////////////////////////
   int insert_rec_b(S32  r,void *p);  // Before 'r'
   int insert_rec_a(S32  r,void *p);  // After  'r'

////////////////////////// Deleting ////////////////////////////////////////////
   void delet(S32  r);

//////////////////////// Number of Records ///////////////////////////////////
   S32  numrec(void)      { return NUMREC; }

////////////////////////// Record Length ///////////////////////////////////////
   U16  length_rec(void)   { return lenrec; }

//////////////////////// Report Writing //////////////////////////////////////
   int  report(csCHAR *name,int sub=1);
   void report(FILE *fipo,int sub);

////////////////////////// Miscellaneous ///////////////////////////////////////
/* Inherited
   int  background(void)
*/

   int pack(void);
   int zap(void);
   void info(void);
   int empty(void);
   virtual int class_ID(void)  { return CS_CLID_IBASE; }



};

#endif
