unit TTabMove;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, arrowbtn, buttons, c_lbhorz;

type
  TTabMv = class(TComponent)
  frm_Tabs : Tform;
  Tab_pnl  : Tpanel;
  Btn_Right: TArrowButton;
  Btn_left : TarrowButton;
  Btn_SaveTabs : TSpeedbutton;
  btn_cancel   : TSpeedbutton;
  btn_BldTabs  : TSpeedButton;
  lbx_DoTab    : TListBoxHorz;
  lbx_DontTab  : TListBoxHorz;
  fDo_FileName  : Shortstring;
  fDont_FileName : Shortstring;
  FOrigOwner : TComponent;
  function Get_Fdo_Filename : shortString;
  function Get_Fdont_Filename : shortString;
  procedure Set_Fdo_Filename(value : ShortString);
  procedure Set_Fdont_Filename(value : ShortString);
  private
    { Private declarations }
  protected
    { Protected declarations }
    procedure CLose_Form(Sender : Tobject);
    procedure DoTab_MouseDown(Sender: TObject; Button: TMouseButton;
                Shift: TShiftState; X, Y: Integer);
    procedure DontTab_MouseDown(Sender: TObject; Button: TMouseButton;
                Shift: TShiftState; X, Y: Integer);
    procedure DoTab_MouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
    procedure DontTab_MouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);


  public
    { Public declarations }
     constructor create(Aowner : Tcomponent);  override;
     destructor Destroy;   override;
     procedure Popup_tablist;
     procedure Dont_to_Do(Sender : Tobject);
     procedure Do_To_Dont(Sender : Tobject);
     procedure Determine_Tabs(Sender : Tobject);
     procedure Save_Tabs(Sender : Tobject);
     procedure Set_tabs;
  published
    { Published declarations }
    property DoTab : shortstring
             read get_FDo_Filename write Set_FDo_Filename;
    property DontTab : shortString
             read get_FDont_Filename write sET_FDont_Filename;
  end;

procedure Register;

implementation
var
   ugl_DoTabPos : integer;
   ugl_DontTabPos : integer;

procedure TTabMv.Set_tabs;
var
   l_ktr : integer;
   l_TabKtr : integer;
begin
  with FOrigOwner do
   begin
    for l_ktr := 0 to componentCount - 1 do
      begin
        if Components[l_ktr] is TWinControl then
          begin
                for l_TabKtr := 0 to lbx_doTab.items.count - 1 do
                  begin
                     with components[l_ktr] as TWinControl do
                     begin
                     if name = lbx_doTab.items[l_tabKtr] then
                        begin
                           tabstop := true;
                           tabOrder := l_TabKtr;
                        end;
                     end;  (* with *)
                  end;  (* l_TabKtr *)
           end; (* if TWinControl *)
        end; (* for l_ktr *)
   end;  (* with/do *)

   (*--------------- set the dont do tab list --------------- *)
  with FOrigOwner do
   begin
    for l_ktr := 0 to componentCount - 1 do
      begin
        if Components[l_ktr] is TWinControl then
          begin
                for l_TabKtr := 0 to lbx_dontTab.items.count - 1 do
                  begin
                     with components[l_ktr] as TWinControl do
                     begin
                     if name = lbx_dontTab.items[l_tabKtr] then
                        begin
                           tabstop := false;
                           tabOrder := l_TabKtr;
                        end;
                     end;  (* with *)
                  end;  (* l_TabKtr *)
           end; (* if TWinControl *)
        end; (* for l_ktr *)
   end;  (* with/do *)


end;



function TTabMv.Get_Fdo_Filename : shortString;
begin
   result := fdo_filename;
end;
procedure TTaBmV.Set_Fdo_filename(value : ShortString);
begin
   FDo_Filename := value;
end;

function TTabMv.Get_Fdont_Filename : shortString;
begin
   result := fdont_filename;
end;

procedure TTaBmV.Set_Fdont_filename(value : ShortString);
begin
   FDont_Filename := value;
end;

procedure TTabMv.Save_Tabs(Sender : Tobject);
var
   l_file : Textfile;
   l_ktr : integer;
   l_done : boolean;
   l_str : string;
begin
   assignfile(l_file,FDo_Filename);
   rewrite(l_File);
   l_ktr := 0;
   l_done := false;
   repeat
      try
         l_str := lbx_doTab.items[l_ktr];
         writeln(l_file,l_str);
         inc(l_ktr);
      except
         l_done := true;
      end;
   until l_done;
   closefile(l_file);

   assignfile(l_file,FDont_Filename);
   rewrite(l_File);
   l_ktr := 0;
   l_done := false;
   repeat
      try
         l_str := lbx_dontTab.items[l_ktr];
         writeln(l_file,l_str);
         inc(l_ktr);
      except
         l_done := true;
      end;
   until l_done;
   closefile(l_file);
   close_form(frm_tabs);
   set_tabs;
end;

procedure TTabMv.DoTab_MouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
begin
   lbx_doTab.items.move(ugl_DoTabPos, lbx_doTab.itemindex);
end;

procedure TTabMv.DontTab_MouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
begin
   lbx_dontTab.items.move(ugl_DontTabPos,lbx_dontTab.itemindex);
end;

procedure TTabMv.DoTab_MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   ugl_DoTabPos := lbx_DoTab.itemindex;
end;
procedure TTabMv.DontTab_Mousedown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   ugl_DontTabPos := lbx_DontTab.itemindex;
end;


procedure TTabMv.Determine_tabs(Sender : Tobject);
var
   l_ktr : integer;
begin
  lbx_doTab.clear;
  lbx_dontTab.clear;
  with FOrigOwner do
   begin
    for l_ktr := 0 to componentCount - 1 do
      begin
       if components[l_ktr] is TWinControl then
         begin
          with components[l_ktr] as TWinControl do
             begin
              if tabStop then
                 lbx_doTab.items.add(name);
             end;  (* with as *)
         end;
      end;
    end;
//
end;
procedure TTabMv.Close_Form(Sender : Tobject);
begin
   frm_tabs.close;
end;

procedure TTabMv.Dont_to_Do(Sender : Tobject);
begin
   if lbx_dontTab.itemindex = -1 then exit;
   lbx_doTab.items.add(lbx_dontTab.items[lbx_dontTab.itemindex]);
   lbx_dontTab.items.delete(lbx_dontTab.itemindex);
end;
procedure TTabMv.Do_to_Dont(Sender : Tobject);
begin
   if lbx_doTab.itemindex = -1 then exit;
   lbx_dontTab.items.add(lbx_doTab.items[lbx_doTab.itemindex]);
   lbx_doTab.items.delete(lbx_doTab.itemindex);
end;

procedure TTabMv.popup_tablist;
begin
   (* Make form first *)
   frm_tabs := TForm.create(Self);
   with frm_tabs do
      begin
         left := 200;
         top  := 108;
         borderstyle := bsDialog;
         Caption := 'Tab Adjust';
         ClientHeight := 230;
         ClientWidth := 391;
      end;
   (* Make panel second *)
   tab_Pnl := Tpanel.create(Self);
   with tab_pnl do
      begin
         parent := Frm_Tabs;
         left := 0;
         top := 0;
         align := alTop;
         BevelInner := bvLowered;
         borderwidth := 4;
         Borderstyle := bsSingle;
         height := 45;
         caption := '';
      end;
   Btn_Right := TarrowButton.create(Self);
   with Btn_right do
      begin
         parent := Frm_Tabs;
         left := 172;
         top := 72;
         width := 33;
         Height := 33;
         ButtonColor := clLime;
         Direction := arwRight;
         OnClick := Do_To_Dont;
      end;
   btn_Left := TarrowButton.create(Self);
   with Btn_left do
      begin
         parent := Frm_Tabs;
         left := 188;
         top := 128;
         width := 33;
         Height := 33;
         ButtonColor := clAqua;
         Direction := arwLeft;
         OnClick := Dont_to_Do;
      end;
   Btn_SaveTabs := TSpeedButton.create(self);
   with btn_saveTabs do
      begin
         parent := tab_Pnl;
         left := 6;
         top := 7;
         width := 107;
         height := 28;
         Caption := '&Save Tab Order';
         onClick := Save_Tabs;
      end;
   Btn_Cancel := TSpeedButton.create(self);
   with btn_Cancel do
      begin
         parent := tab_Pnl;
         left := 118;
         top := 7;
         width := 107;
         height := 28;
         Caption := '&Cancel';
         OnClick := Close_Form;
      end;
  Btn_BldTabs := TSpeedButton.create(Self);
  with btn_BldTabs do
     begin
         parent := tab_Pnl;
        left := 274;
        top := 7;
        width := 107;
        height := 28;
        caption := '&Bld Tab List';
        visible := true;     //////////////////////////////////////////////
        onClick := Determine_Tabs;
     end;
  lbx_DoTab := TListBoxHorz.create(Self);
  WITH LBX_DoTab do
     begin
         parent := Frm_Tabs;
        left := 0;
        top := 45;
        width := 169;
        height := 185;
        align := alLeft;
        ItemHeight := 13;
        ScrollWidth := 0;
        OnMouseDown :=  DoTab_MouseDown;
        OnMouseUp := DoTab_MouseUp;
     end;
  lbx_DoTab.clear;
     (* Dont listbox *)
  lbx_DontTab := TListBoxHorz.create(Self);
  WITH LBX_DontTab do
     begin
         parent := Frm_Tabs;
        left := 0;
        top := 45;
        width := 169;
        height := 185;
        align := alright;
        ItemHeight := 13;
        ScrollWidth := 0;
        OnMouseDown :=  DontTab_MouseDown;
        OnMouseUp := DontTab_MouseUp;
     end;
  lbx_DontTab.clear;
  try    // try to load...if nothing there, that's ok
     lbx_doTab.items.loadfromfile(FDo_Filename);
     lbx_dontTab.items.loadfromFile(FDont_filename);
     Set_tabs;
  except
  end;
end;  // end of procedure popup


Constructor TTabMv.create(Aowner : Tcomponent);
begin
   inherited create(Aowner);
   FOrigOwner := Aowner;
   fDo_filename := 'DoTab.dat';       //////////////////////////////////////
   FDont_filename := 'DontTab.dat';   //////////////////////////////////////
   popup_tablist;
end;
Destructor TTabMv.Destroy;
begin
  lbx_dontTab.free;
  lbx_DoTab.free;
  btn_BldTabs.free;
  btn_Cancel.free;
  btn_SaveTabs.free;
  btn_Left.free;
  btn_Right.free;
  tab_pnl.free;
  frm_tabs.free;
  inherited destroy;
end;






procedure Register;
begin
  RegisterComponents('Extra', [TTabMv]);
end;

end.
