unit SQLedit;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls,DBTables;

type
  TSQLeditor = class(TForm)
    CloseBtn: TButton;
    Bevel1: TBevel;
    MemoSQL: TMemo;
    Apply: TButton;
    ToggleActive: TButton;
    Revert: TButton;
    procedure ToggleActiveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ApplyClick(Sender: TObject);
    procedure RevertClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
  private
    { Private declarations }

  public
    { Public declarations }
    Query:TQuery;

    strlistTemp:TStringList;
  end;

var
  SQLeditor: TSQLeditor;

implementation

{$R *.DFM}

procedure TSQLeditor.ToggleActiveClick(Sender: TObject);
begin
  Query.Active:=not Query.Active;
end;

procedure TSQLeditor.FormCreate(Sender: TObject);
begin
   if Query<>nil then
   begin
      MemoSQL.clear;
      MemoSQL.lines.addstrings(Query.SQL);
   end;

   strlistTemp:=TstringList.create;
end;

procedure TSQLeditor.ApplyClick(Sender: TObject);
var
    SActive:boolean;
begin
   SActive:=Query.active;
   query.active:=false;

   strlistTemp.clear;
   strlistTemp.addstrings(Query.sql);

   query.sql.clear;
   query.sql.addstrings(MemoSQL.lines);

   query.active:=SActive;
end;

procedure TSQLeditor.RevertClick(Sender: TObject);
var
    SActive:boolean;
begin
   SActive:=Query.active;
   query.active:=false;

   query.sql.clear;
   query.sql.addstrings(strlistTemp);

   query.active:=SActive;

end;

procedure TSQLeditor.CloseBtnClick(Sender: TObject);
begin
  strlistTemp.clear;
end;

initialization
begin
  SQLeditor:=TSQLeditor.create(nil)
end;

finalization
begin
  SQLeditor.free;
end;
end.
