{ INT2Tph. Main module for the Interrupt List -> .TPH compiler.}
{ The software included, data formats and basic algorithms are }
{ copyright (C) 1996 by Slava Gostrenko. All rights reserved.  }

{$M 16384}
{$IFNDEF DPMI}
  ! set Target to 'Protected Mode Application'
{$ENDIF}

{$X+}
program
  Int2TPH;

uses
  Upcaser, Objects, TPH;

type
  PString32 = ^TString32;
  TString32 = string [32];

const
  ExtendedIndex: Boolean = True;

var
  FO: THelpFile;
  IncompPattern: Text;
  Hdrs: TStringCollection;
  IntLists: array [Byte] of PTopic;
  IntNames: array [Byte] of string [12];
  KeyLists: TCollection;
  KeyNames: TCollection;
  IntList: PTopic;
  IntListName: string;
  Tables: PTopic;
  TablesName: string;
  CMOS: PTopic;
  CMOSName: string;
  FarCall: PTopic;
  FarCallName: string;
  Memory: PTopic;
  MemoryName: string;
  Ports: PTopic;
  PortsName: string;

  IntListIndex: PTopic;
  IntListIndexName: string;

const HexCh: array [0..$F] of Char = '0123456789ABCDEF';
function HexWord (W: Word): string;
begin
  HexWord := HexCh[Hi(W) shr 4] + HexCh[Hi(W) and $F]
           + HexCh[Lo(W) shr 4] + HexCh[Lo(W) and $F];
end;
function HexByte (B: Byte): string;
begin
  HexByte := HexCh[B shr 4] + HexCh[B and $F];
end;

function MemInitSwapFile(FileName: PChar; FileSize: Longint): Integer; far; external 'RTM' Index 35;
function MemCloseSwapFile(Delete: Integer): Integer; far; external 'RTM' Index 36;

function MakeCorrectTopicName (const TopicName: string): string;
var
  I: Integer;
  V: Integer;
  AddChar, TstTopic: string;
  Rez: string;
begin
  Rez := TopicName;

  if Length (Rez) > 31 then
    Rez [0] := #31;

  V := 0;

  if Length (Rez) = 31 then
    AddChar := '   '
  else
  if Length (Rez) = 30 then
    AddChar := '  '
  else
  if Length (Rez) = 29 then
    AddChar := ' '
  else
    AddChar := '';

  TstTopic := StUpcase2 (Rez);
  while Hdrs. Search (@TstTopic, I) do begin
    Dec (Rez [0], Length (AddChar));
    Inc (V);
    if V > 99 then
      WriteLn ('error 3');

    System. Str (V, AddChar);
    if Length (AddChar) = 1 then
      AddChar := '_0' + AddChar
    else
      AddChar := '_'  + AddChar;

    Rez := Rez + AddChar;
    TstTopic := StUpcase2 (Rez);
  end;

  Hdrs. Insert (NewStr (TstTopic));

  MakeCorrectTopicName := Rez;
end;

function ProcessPattern (var Str: string; var Pos: Integer;
                         Pattern: string; Keyword: string;
                         Topic: PTopic; StepBack: Integer): Boolean;
var I, J: Integer;
begin
  I := 1;
  while I <= Length (Pattern) do begin
    if Pattern [I] in [#3, #6] then
      if Upcase [Str [Pos + I - 1]] in HexChars + ['X'] then begin
        J := System. Pos (#3, Keyword);
        if J > 0 then
          Keyword [J] := Str [Pos + I - 1]
        else
          if Pattern [I] = #3 then begin
            WriteLn (Str);
            WriteLn ('error in keyword pattern (1) ', Pattern, ' ', Keyword);
            ProcessPattern := False;
            Exit;
          end;
      end else begin
        ProcessPattern := False;
        Exit;
      end
    else
    if Pattern [I] in [#4, #7] then begin
      if (  (Upcase [Str [Pos + I - 1]] in ['B', 'C', 'D'])
        and (Upcase [Str [Pos + I]] in ['X', 'L', 'H']))
      or (  (Upcase [Str [Pos + I - 1]] in ['S', 'D'])
        and (Upcase [Str [Pos + I]] = 'I'))
      or (  (Upcase [Str [Pos + I - 1]] in ['B', 'S'])
        and (Upcase [Str [Pos + I]] = 'P'))
      or (  (Upcase [Str [Pos + I - 1]] in ['D', 'E', 'S', 'F', 'G'])
        and (Upcase [Str [Pos + I]] = 'S'))
      or (  (Upcase [Str [Pos + I - 1]] = 'S')
        and (Upcase [Str [Pos + I]] = 'F'))
      then begin
        J := System. Pos (#4, Keyword);
        if J > 0 then begin
          Keyword [J] := Str [Pos + I - 1];
          Keyword [J + 1] := Str [Pos + I];
          Inc (I);
        end else
          if Pattern [I] = #4 then begin
            WriteLn (Str);
            WriteLn ('error in keyword pattern (2) ', Pattern, ' ', Keyword);
            ProcessPattern := False;
            Exit;
          end else
            Inc (I);
      end else begin
        ProcessPattern := False;
        Exit;
      end
    end else
    if Pattern [I] in [#5, #8] then begin
      if (  (Upcase [Str [Pos + I - 1]] in ['B', 'C', 'D'])
        and (Upcase [Str [Pos + I]] in ['X', 'L', 'H']))
      or (  (Upcase [Str [Pos + I - 1]] = 'S')
        and (Upcase [Str [Pos + I]] = 'F'))
      then begin
        J := System. Pos (#5, Keyword);
        if J > 0 then begin
          Keyword [J] := Str [Pos + I - 1];
          Keyword [J + 1] := Str [Pos + I];
          Inc (I);
        end else
          if Pattern [I] = #5 then begin
            WriteLn (Str);
            WriteLn ('error in keyword pattern (3) ', Pattern, ' ', Keyword);
            ProcessPattern := False;
            Exit;
          end else
            Inc (I);
      end else begin
        ProcessPattern := False;
        Exit;
      end
    end else
    if ((Pattern [I] = 'X') and (Upcase [Str [Pos + I - 1]] in ['L', 'H']))
    or ((Pattern [I] in ['L', 'H']) and (Upcase [Str [Pos + I - 1]] = 'X'))
    then
      {Ok}
    else
    if Pattern [I] = 'H' then begin
      if Upcase [Str [Pos + I - 1]] <> 'H' then begin
        Delete (Pattern, I, 1);
        Dec (I);
      end;
    end else
    if Upcase [Str [Pos + I - 1]] <> Upcase [Pattern [I]] then begin
      ProcessPattern := False;
      Exit;
    end;

    Inc (I);
  end;

  {Once user's request for pattern with helper was confirmed}
  {make the pattern suitable for helper string analizis.    }
  if Pattern [Length (Pattern)] = '"' then
    Dec (Pattern [0]);

  if  (Pos + Length (Pattern) - 1 > Length (Str))
  and (Pattern [Length (Pattern)] in ['h', 'H']) then
    Dec (Pattern [0]);

  if Pos + Length (Pattern) - 1 <= Length (Str) then begin
    if (System. Pos (#3, Keyword) > 0)
    or (System. Pos (#4, Keyword) > 0)
    or (System. Pos (#5, Keyword) > 0) then begin
      WriteLn (Str);
      WriteLn ('error in keyword pattern (4) ', Pattern, ' ', Keyword);
    end;

    if  (Length (Keyword) < 13)
    and (Pos + Length (Pattern) <= Length (Str))
    and (Str [Pos + Length (Pattern)] in (['/', 'h', 'H', ':', '-'] + HexChars))
    and (Pos + Length (Pattern) + 1 <= Length (Str))
    and (not (Str [Pos + Length (Pattern) + 1] in ['I', 'R', 'W', '-', ' ']))
    then begin
      WriteLn (IncompPattern, Str);
      WriteLn (IncompPattern, 'not a complete pattern ', Pattern, ' for keyword ', Keyword);
    end;

    if  (Pos + Length (Pattern) <= Length (Str))
    and (Str [Pos + Length (Pattern)] = '"') then begin
      Keyword := Keyword + '"';
      I := Pos + Length (Pattern) + 1;
      while (I <= Length (Str)) and (Str [I] <> '"') do begin
        Keyword := Keyword + Str [I];
        Inc (I);
      end;
      if I <= Length (Str) then begin
        Keyword := Keyword + '"';
        if Copy (Keyword, 1, 4) = 'INT ' then
          Delete (Keyword, 1, 4);
      end else
        Delete (Keyword, System.Pos ('"', Keyword), Length (Keyword));
    end;

    Topic^. AddKeyword (Keyword, StepBack);
    Insert (#2, Str, Pos + Length (Pattern));
    Insert (#2, Str, Pos);
    Inc (Pos, Length (Pattern) + 1);

    ProcessPattern := True;
  end else
    ProcessPattern := False;
end;

function SkipPattern (var Str: string; var Pos: Integer;
                      Pattern: string): Boolean;
var I, J: Integer;
begin
  I := 1;
  while I <= Length (Pattern) do begin
    if Pattern [I] = #3 then
      if Upcase [Str [Pos + I - 1]] in HexChars + ['X'] then begin
        {Ok}
      end else begin
        SkipPattern := False;
        Exit;
      end
    else
    if Pattern [I] = #4 then begin
      if (  (Upcase [Str [Pos + I - 1]] in ['B', 'C', 'D'])
        and (Upcase [Str [Pos + I]] in ['X', 'L', 'H']))
      or (  (Upcase [Str [Pos + I - 1]] in ['S', 'D'])
        and (Upcase [Str [Pos + I]] = 'I'))
      or (  (Upcase [Str [Pos + I - 1]] in ['B', 'S'])
        and (Upcase [Str [Pos + I]] = 'P'))
      or (  (Upcase [Str [Pos + I - 1]] in ['D', 'E', 'S', 'F', 'G'])
        and (Upcase [Str [Pos + I]] = 'S'))
      or (  (Upcase [Str [Pos + I - 1]] = 'S')
        and (Upcase [Str [Pos + I]] = 'F'))
      then begin
        {Ok}
      end else begin
        SkipPattern := False;
        Exit;
      end
    end else
    if Pattern [I] = #5 then begin
      if (  (Upcase [Str [Pos + I - 1]] in ['B', 'C', 'D'])
        and (Upcase [Str [Pos + I]] in ['X', 'L', 'H']))
      or (  (Upcase [Str [Pos + I - 1]] = 'S')
        and (Upcase [Str [Pos + I]] = 'F'))
      then begin
        {Ok}
      end else begin
        SkipPattern := False;
        Exit;
      end
    end else
    if ((Pattern [I] = 'X') and (Upcase [Str [Pos + I - 1]] in ['L', 'H']))
    or ((Pattern [I] in ['L', 'H']) and (Upcase [Str [Pos + I - 1]] = 'X'))
    then
      {Ok}
    else
    if Pattern [I] = 'H' then begin
      if Upcase [Str [Pos + I - 1]] <> 'H' then begin
        Delete (Pattern, I, 1);
        Dec (I);
      end;
    end else
    if Upcase [Str [Pos + I - 1]] <> Upcase [Pattern [I]] then begin
      SkipPattern := False;
      Exit;
    end;

    Inc (I);
  end;

  if Pos + Length (Pattern) - 1 <= Length (Str) then begin
    if  (Pos + Length (Pattern) <= Length (Str))
    and (Str [Pos + Length (Pattern)] in (['/', 'h', 'H', ':', '-'] + HexChars))
    and (Pos + Length (Pattern) + 1 <= Length (Str))
    and (not (Str [Pos + Length (Pattern) + 1] in ['I', 'R', 'W', '-', ' ']))
    then begin
      WriteLn (IncompPattern, Str);
      WriteLn (IncompPattern, 'not a complete pattern ', Pattern);
    end;

    Inc (Pos, Length (Pattern) - 1);

    SkipPattern := True;
  end else
    SkipPattern := False;
end;

procedure AddStr2Topic (Str: string; var Topic: PTopic;
                        var TopicName: string; const CurInt, CurSubF, CurCat: string;
                        Indexed: Boolean);
var I: Integer;
    KeyCnt: Integer;
    OldTopicName: string;
    OldTopicCount: Word;
begin
  KeyCnt := 0;
  for I := 1 to Length (Str) do
    if Str [I] = #2 then
      Inc (KeyCnt);

  I := 1;
  while I <= Length (Str) do begin
    if Str [I] = #2 then
      Dec (KeyCnt);

    if not Odd (KeyCnt) then
      if  (I + 4 <= Length (Str))
      and (Str [I] = '#')
      and (Str [I + 1] in ['0'..'9', 'C', 'F', 'M', 'P'])
      and (Str [I + 2] in ['0'..'9'])
      and (Str [I + 3] in ['0'..'9'])
      and (Str [I + 4] in ['0'..'9'])
      then begin
        Topic^. AddKeyword (Copy (Str, I, 5), KeyCnt div 2);
        Insert (#2, Str, I + 5);
        Insert (#2, Str, I);
        Inc (I, 6);
      end else
        if (I = 1)
        or (not (Upcase [Str [I - 1]] in ['A'..'Z', '0'..'9'])) then
          case Upcase [Str [I]] of
          'I':
            if ProcessPattern (Str, I, 'INT '#3#3'H/AX='#3#3#3#3'H/'#4#4'='#3#3#3#3'H',
                 #3#3#3#3#3#3#4#4#3#3#3#3 + CurCat, Topic, KeyCnt div 2)

            or ProcessPattern (Str, I, 'INT 13/AX=2000H/DL=81H', '1320' + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H/AX='#3#3#3#3'H/'#5#5'='#3#3'H',
                 #3#3#3#3#3#3#5#5#3#3 + CurCat, Topic, KeyCnt div 2)

            or ProcessPattern (Str, I, 'INT 21/AX=4202H/CX=0/DX=0', '2142' + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H/AX='#6#6#6#6'H-'#6#6#6#6'H',
                 'INT '#3#3, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H/AX='#3#3#3#3'H',
                 #3#3#3#3#3#3 + CurCat, Topic, KeyCnt div 2)

            or ProcessPattern (Str, I, 'INT '#3#3'H/AH='#3#3#3#3'H',
                 #3#3#3#3#3#3 + CurCat, Topic, KeyCnt div 2)

            or ProcessPattern (Str, I, 'INT '#3#3'H/AH='#3#3'H/'#4#4'='#3#3#3#3'H',
                 #3#3#3#3'--'#4#4#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H/AH='#3#3'H/'#5#5'='#3#3'H',
                 #3#3#3#3'--'#5#5#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H/AH='#6#6'H-'#6#6'H',
                 'INT '#3#3, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H/AH='#3#3'H',
                 #3#3#3#3 + CurCat, Topic, KeyCnt div 2)

            or ProcessPattern (Str, I, 'INT '#3#3'H/AL='#3#3'H/'#4#4'='#3#3#3#3'H',
                 #3#3'--'#3#3#4#4#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H/AL='#3#3'H/'#5#5'='#3#3'H',
                 #3#3'--'#3#3#5#5#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H/AL='#3#3'H',
                 #3#3'--'#3#3 + CurCat, Topic, KeyCnt div 2)

            or ProcessPattern (Str, I, 'INT '#3#3'H/'#4#4'='#3#3#3#3'H',
                 #3#3'----'#4#4#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H/'#5#5'='#3#3'H',
                 #3#3'----'#5#5#3#3 + CurCat, Topic, KeyCnt div 2)

            or ProcessPattern (Str, I, 'INT '#3#3'H/'#3#3#3#3'H',
                 #3#3#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H/'#6#6'H-'#6#6'H',
                 'INT '#3#3, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H/'#3#3'H',
                 #3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#6#6'-INT '#6#6'H',
                 'TITLES', Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#6#6'-'#6#6'H',
                 'TITLES', Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT XXH',
                 'TITLES', Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'INT '#3#3'H',
                 'INT '#3#3, Topic, KeyCnt div 2)
            then
              ;
          'A':
            if ProcessPattern (Str, I, 'AX='#3#3#3#3'H/'#4#4'='#3#3#3#3'H',
                 CurInt + #3#3#3#3#4#4#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'AX='#3#3#3#3'H/'#5#5'='#3#3'H',
                 CurInt + #3#3#3#3#5#5#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'AX='#6#6#6#6'H-'#6#6#6#6'H',
                 'INT ' + CurInt, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'AX='#3#3#3#3'H',
                 CurInt + #3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'AH='#3#3'H/AL='#3#3'H',
                 CurInt + #3#3#3#3 + CurCat, Topic, KeyCnt div 2)

            or ProcessPattern (Str, I, 'AH='#3#3'H/'#4#4'='#3#3#3#3'H',
                 CurInt + #3#3'--'#4#4#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'AH='#3#3'H/'#5#5'='#3#3'H',
                 CurInt + #3#3'--'#5#5#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'AH='#6#6'H-'#6#6'H',
                 'INT ' + CurInt, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'AH='#3#3'H',
                 CurInt + #3#3 + CurCat, Topic, KeyCnt div 2)

            or ProcessPattern (Str, I, 'AL='#3#3'H/'#4#4'='#3#3#3#3'H',
                 CurInt + Copy (CurSubF, 1, 2) + #3#3#4#4#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'AL='#3#3'H/'#5#5'='#3#3'H',
                 CurInt + Copy (CurSubF, 1, 2) + #3#3#5#5#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'AL='#6#6'H/'#6#6'H',
                 CurInt + Copy (CurSubF, 1, 2) + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'AL='#6#6'H-'#6#6'H',
                 CurInt + Copy (CurSubF, 1, 2) + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'AL='#3#3'H',
                 CurInt + Copy (CurSubF, 1, 2) + #3#3 + CurCat, Topic, KeyCnt div 2)
            then
              ;
          'B', 'C', 'D', 'S', 'E', 'F', 'G':
            if ProcessPattern (Str, I, #4#4'='#3#3#3#3'H',
                 CurInt + CurSubF + #4#4#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or SkipPattern (Str, I, 'CX=CX-1')
            or ProcessPattern (Str, I, #8#8'='#6#6'H/'#6#6'H',
                 CurInt + CurSubF + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, #8#8'='#6#6'H-'#6#6'H',
                 CurInt + CurSubF + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, #5#5'='#3#3'H',
                 CurInt + CurSubF + #5#5#3#3 + CurCat, Topic, KeyCnt div 2)
            then
              {nothing}
            else
            if Upcase [Str [I]] = 'C' then begin
              if ProcessPattern (Str, I, 'CMOS DATA',
                   'CMOS', Topic, KeyCnt div 2)
              or ProcessPattern (Str, I, 'CMOS 8086/88',
                   'CMOS', Topic, KeyCnt div 2)
              or ProcessPattern (Str, I, 'CMOS 80C86/88',
                   'CMOS', Topic, KeyCnt div 2)
              or ProcessPattern (Str, I, 'CMOS '#3#3#3#3'H',
                   'R'#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
              or ProcessPattern (Str, I, 'CMOS '#3#3'H-'#3#3'H',
                   'R'#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
              or ProcessPattern (Str, I, 'CMOS '#3#3'H',
                   'R'#3#3 + CurCat, Topic, KeyCnt div 2)
              or ProcessPattern (Str, I, 'CMOS',
                   'CMOS', Topic, KeyCnt div 2)

              or ProcessPattern (Str, I, 'CALL XXXXH:XXXXH"',
                   '@xxxxxxxx', Topic, KeyCnt div 2)
              or ProcessPattern (Str, I, 'CALL XXXXH:XXXXH',
                   'FAR CALLS', Topic, KeyCnt div 2)
              or ProcessPattern (Str, I, 'CALL '#3#3#3#3'H:'#3#3#3#3'H',
                 '@'#3#3#3#3#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
              then
                ;
            end;
          '@':
            if ProcessPattern (Str, I, '@XXXXH:XXXXH"',
                 '@xxxxxxxx', Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, '@XXXXH:XXXXH',
                 'FAR CALLS', Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, '@'#3#3#3#3'H:'#3#3#3#3'H',
                 '@'#3#3#3#3#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            then
              ;
          'M':
            if ProcessPattern (Str, I, 'MEM '#6#6#6#6'H:xxxxH',
                 'MEMORY', Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'MEM '#3#3#3#3'H:'#3#3#3#3'H',
                 'M'#3#3#3#3#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'MEM '#3#3#3#3#3#3#3#3'H',
                 'M'#3#3#3#3#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            then
              ;
          'P':
            if ProcessPattern (Str, I, 'PORT ACCESS',
                 'PORTS', Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'PORT '#3#3#3#3'H-'#3#3#3#3'H',
                 'P'#3#3#3#3#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'PORT '#3#3#3#3'H-'#3#3#3'H',
                 'P'#3#3#3#3#3#3#3' ' + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'PORT '#3#3#3#3'H-????H',
                 'P'#3#3#3#3'????' + CurCat, Topic, KeyCnt div 2)
            or ProcessPattern (Str, I, 'PORT '#3#3#3#3'H',
                 'P'#3#3#3#3 + CurCat, Topic, KeyCnt div 2)
            then
              ;
          end;

    Inc (I);
  end;

  Topic^. AddString (' ' + Str);

  if Topic^. Size > (65536 * 2) div 3 then begin
    WriteLn ('topic ', TopicName, ' will be splited, index mode - ', Indexed);

    OldTopicName := TopicName;
    OldTopicCount := Topic^.Count;

    TopicName := TopicName + '_';
    TopicName := MakeCorrectTopicName (TopicName);

    Topic^. AddKeyword (TopicName, 0);
    Topic^. AddString (' '#2'next page'#2);

    FO. IdxTbl. Insert (New (PIndexEntry, Init (
      OldTopicName, '', 0, Topic, Indexed)));

    New (Topic, Init (1, 1));

    Topic^. AddKeyword (OldTopicName, 0);
    Topic^. AddString (' '#2'previous page'#2);
  end;
end;

function ProcessInterrup (const FileName: string; const FileIsATopic: string): Boolean;
type
  DividerRec = record
    Len: Byte;
    S: array [0..7] of Char;   (* '--------' *)
    Cat: Char;                 (* category *)
    C: Char;                   (* '-' *)
    case Integer of
      0: (Int: array [0..1] of Char; (* Interrupt number, 2 hex digits *)
          SubF: array [0..3] of Char;(* sub function, 4 hex digits or '-' *)
          R: array [0..1] of Char;   (* Secondary Register Name, Two Letters or '--' *)
          RV: array [0..3] of Char;  (* sec. reg. value, 4 hex digits or '-' *)
          Rest: array [0..17] of Char;
         );
      1: (RSign: Char;
          R1,
          R2: array [0..1] of Char;
         );
      2: (AtSign: Char;
          CallSeg,
          CallOfs: array [0..3] of Char;
         );
      3: (MSign: Char;
          MemSeg,
          MemOfs: array [0..3] of Char;
         );
      4: (PSign: Char;
          P1,
          P2: array [0..3] of Char;
         );
  end;            (* record dividerRec *)

  T2W = record Lo, Hi: Word; end;
  T22 = record Lo, Hi: array [0..1] of Char; end;

var
  FI: Text;
  Str, StrUp: string;
  TopicName: string;

  CurCat: string [1];
  CurInt: string [2];
  CurSubF: string [4];

  DR: DividerRec absolute Str;

procedure ProcessHdr (Hdr: string);
begin
  with DR do begin
    if (S <> '--------')
    or (not (Cat in ['A'..'Z', 'a'..'z', '!', '*', '-']))
    or (C <> '-')
    or ((Cat <> '!')
        and
        ((not (RSign in ['R', 'r']))
      or (not (R1 [0] in HexChars))
      or (not (R1 [1] in HexChars))
      or (  (R2 <> '--')
        and ((not (R2 [0] in HexChars))
          or (not (R2 [1] in HexChars)))
         )
        )
        and
        ((not (AtSign = '@'))
      or (not (CallSeg [0] in HexChars + ['x']))
      or (not (CallSeg [1] in HexChars + ['x']))
      or (not (CallSeg [2] in HexChars + ['x']))
      or (not (CallSeg [3] in HexChars + ['x']))
      or (not (CallOfs [0] in HexChars + ['x']))
      or (not (CallOfs [1] in HexChars + ['x']))
      or (not (CallOfs [2] in HexChars + ['x']))
      or (not (CallOfs [3] in HexChars + ['x']))
        )
        and
        ((not (MSign in ['M', 'm']))
      or (not (MemSeg [0] in HexChars + ['x']))
      or (not (MemSeg [1] in HexChars + ['x']))
      or (not (MemSeg [2] in HexChars + ['x']))
      or (not (MemSeg [3] in HexChars + ['x']))
      or (not (MemOfs [0] in HexChars + ['x']))
      or (not (MemOfs [1] in HexChars + ['x']))
      or (not (MemOfs [2] in HexChars + ['x']))
      or (not (MemOfs [3] in HexChars + ['x']))
        )
        and
        ((not (PSign in ['P', 'p']))
      or (not (P1 [0] in HexChars))
      or (not (P1 [1] in HexChars))
      or (not (P1 [2] in HexChars))
      or (not (P1 [3] in HexChars))
      or (  (P2 <> '----')
        and (P2 <> '????')
        and ((not (P2 [0] in HexChars))
          or (not (P2 [1] in HexChars))
          or (not (P2 [2] in HexChars))
          or (not (P2 [3] in HexChars + ['x', ' '])))
         )
        )
        and
        ((not (Int [0] in HexChars))
      or (not (Int [1] in HexChars))
      or (  (SubF <> '----')
        and ((T22 (SubF). Lo <> '--')
          or (not (SubF [2] in HexChars))
          or (not (SubF [3] in HexChars)))
        and ((T22 (SubF). Hi <> '--')
          or (not (SubF [0] in HexChars))
          or (not (SubF [1] in HexChars)))
        and ((not (SubF [0] in HexChars))
          or (not (SubF [1] in HexChars))
          or (not (SubF [2] in HexChars))
          or (not (SubF [3] in HexChars)))
         )
      or (  (R <> '--')
        and ((R <> 'BX') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (not (RV [2] in HexChars))
                         or (not (RV [3] in HexChars)))
        and ((R <> 'CX') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (not (RV [2] in HexChars))
                         or (not (RV [3] in HexChars)))
        and ((R <> 'DX') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (not (RV [2] in HexChars))
                         or (not (RV [3] in HexChars)))
        and ((R <> 'SI') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (not (RV [2] in HexChars))
                         or (not (RV [3] in HexChars)))
        and ((R <> 'DI') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (not (RV [2] in HexChars))
                         or (not (RV [3] in HexChars)))
        and ((R <> 'SP') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (not (RV [2] in HexChars))
                         or (not (RV [3] in HexChars)))
        and ((R <> 'BP') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (not (RV [2] in HexChars))
                         or (not (RV [3] in HexChars)))
        and ((R <> 'ES') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (not (RV [2] in HexChars))
                         or (not (RV [3] in HexChars)))
        and ((R <> 'DS') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (not (RV [2] in HexChars))
                         or (not (RV [3] in HexChars)))

        and ((R <> 'BH') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (T22 (RV). Hi <> '--'))
        and ((R <> 'BL') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (T22 (RV). Hi <> '--'))
        and ((R <> 'CH') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (T22 (RV). Hi <> '--'))
        and ((R <> 'CL') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (T22 (RV). Hi <> '--'))
        and ((R <> 'DH') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (T22 (RV). Hi <> '--'))
        and ((R <> 'DL') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (T22 (RV). Hi <> '--'))

        and ((R <> 'SF') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (not (RV [2] in HexChars))
                         or (not (RV [3] in HexChars)))
        and ((R <> 'SF') or (not (RV [0] in HexChars))
                         or (not (RV [1] in HexChars))
                         or (T22 (RV). Hi <> '--'))
         )
      or (Rest <> '------------------')
        )
       )
    then
      WriteLn ('header error: ', Hdr);

    if Cat = '!' then begin
      TopicName := Copy (Str, 10, Length (Str) - 9);
      CurInt := '';
      CurSubF := '';
    end else
      if RSign in ['R', 'r'] then begin
        TopicName := RSign + R1 + R2;
        CurInt := '';
        CurSubF := '';
      end else
      if AtSign = '@' then begin
        TopicName := AtSign + CallSeg + CallOfs;
        CurInt := '';
        CurSubF := '';
      end else
      if MSign in ['M', 'm'] then begin
        TopicName := MSign + MemSeg + MemOfs;
        CurInt := '';
        CurSubF := '';
      end else
      if PSign in ['P', 'p'] then begin
        TopicName := PSign + P1 + P2;
        CurInt := '';
        CurSubF := '';
      end else begin
        TopicName := Int + SubF + R + RV;
        CurInt := Int;
        CurSubF := SubF;
      end;

    while TopicName [Length (TopicName)] = '-' do Dec (TopicName [0]);
    if Length (TopicName) > 0 then
      while TopicName [1] = '-' do Delete (TopicName, 1, 1)
    else
      TopicName := FileName;

    if not (Cat in ['!', '-']) then begin
      TopicName := TopicName + Cat;
      CurCat := Cat;
    end else
      CurCat := '';
  end;
end;

var
  SectionStarted: Boolean;
  SectionClosed: Boolean;
  I, J: Integer;
  Topic: PTopic;
  ExtendedHeader: string;
  OriginalTopicName: string;

  TblStarted: Boolean;
  TblClosed: Boolean;
  TblTopic: PTopic;
  TblTopicName: string;

  PrevStr, SavePtr: PString;
  AddNextStringToTopicAsATblRef: Boolean;

  IndexThisTopic: Boolean;

begin
  Assign (FI, FileName);
  {$I-}
  Reset (FI);
  if IOResult = 0 then begin
    ProcessInterrup := True;
    WriteLn ('processing ', FileName, '                                      ');

    TblStarted := False;
    TblClosed := True;

    SectionStarted := False;
    SectionClosed := True;

    AddNextStringToTopicAsATblRef := False;

    IndexThisTopic := True;

    if FileIsATopic <> '' then begin
      TopicName := FileIsATopic;
      CurCat := '';
      CurInt := '';
      CurSubF := '';

      New (Topic, Init (1, 1));
      SectionStarted := True;
      SectionClosed := False;
      TopicName := MakeCorrectTopicName (TopicName);
      OriginalTopicName := TopicName;
      ExtendedHeader := #2 + TopicName + #2;
    end;

    while not EOF (FI) do begin
      ReadLn (FI, Str);

      if  (Length (Str) > 0)
      and (FileIsATopic = '')
      and ((Str [1] = '-') and (Pos ('--------', Str) <> 0))
      and (Str <> '---------------------------------------------')
      and (Str <> '------------------------------------------------------------------------------')
      then begin
        if not TblClosed then begin
          TblTopic^.AddKeyword (OriginalTopicName, 0);
          AddStr2Topic (ExtendedHeader, TblTopic, TblTopicName, CurInt, CurSubF, CurCat, False);
          FO. IdxTbl. Insert (New (PIndexEntry, Init (
            TblTopicName, '', 0, TblTopic, False)));
          TblStarted := False;
          TblClosed := True;
        end;

        if not SectionClosed then begin
          if Pos ('CMOS', StUpcase2 (FileName)) > 0 then begin
            CMOS^.AddKeyword (OriginalTopicName, 0);
            AddStr2Topic (ExtendedHeader,
                          CMOS, CMOSName, CurInt, CurSubF, CurCat, True);
          end else
          if Pos ('FARCALL', StUpcase2 (FileName)) > 0 then begin
            FarCall^.AddKeyword (OriginalTopicName, 0);
            AddStr2Topic (ExtendedHeader,
                          FarCall, FarCallName, CurInt, CurSubF, CurCat, True);
          end else
          if Pos ('MEMORY', StUpcase2 (FileName)) > 0 then begin
            Memory^.AddKeyword (OriginalTopicName, 0);
            AddStr2Topic (ExtendedHeader,
                          Memory, MemoryName, CurInt, CurSubF, CurCat, True);
          end else
          if Pos ('PORTS', StUpcase2 (FileName)) > 0 then begin
            Ports^.AddKeyword (OriginalTopicName, 0);
            AddStr2Topic (ExtendedHeader,
                          Ports, PortsName, CurInt, CurSubF, CurCat, True);
          end else
          if  (FileIsATopic = '')
          and ((not (ExtendedHeader [2] in HexChars))
            or (not (ExtendedHeader [3] in HexChars)))
          then begin
            IntList^.AddKeyword (OriginalTopicName, 0);
            AddStr2Topic (ExtendedHeader,
                          IntList, IntListName, CurInt, CurSubF, CurCat, True);
          end;

          FO. IdxTbl. Insert (New (PIndexEntry, Init (
            TopicName, '', 0, Topic, IndexThisTopic)));
          IndexThisTopic := True;
          SectionClosed := True;
        end;

        ProcessHdr (Str);

        if (StUpcase2 (TopicName) <> 'SECTION') then begin
          New (Topic, Init (1, 1));
          SectionStarted := True;
          SectionClosed := False;
          TopicName := MakeCorrectTopicName (TopicName);
          OriginalTopicName := TopicName;
          ExtendedHeader := #2 + TopicName + #2;
          Write (TopicName: 31, ' mem - ', MaxAvail: 8, #13);
        end else
          SectionStarted := False;
      end else begin
        if SectionStarted then begin
          I := Pos (#9, Str);
          while I > 0 do begin
            Delete (Str, I, 1);
            for J := 7 downto ((I - 1) mod 8) do
              Insert (' ', Str, I);
            I := Pos (#9, Str);
          end;

          StrUp := StUpcase2 (Str);

          if  (Copy (StrUp, 1, 4) = 'INT ')
          and (StrUp [5] in HexChars) and (StrUp [6] in HexChars)
          and (Pos ('INT', StUpcase2 (FileName)) > 0) then begin
            I := (Pos (StrUp [5], HexCh) - 1)*16 + Pos (StrUp [6], HexCh) - 1;
            IntLists [I]^.AddKeyword (OriginalTopicName, 0);
            ExtendedHeader := #2 + TopicName + #2
                            + Copy (Str, 7, Length (Str) - 6);
            AddStr2Topic (ExtendedHeader,
                          IntLists [I], string (Pointer(@IntNames [I])^), CurInt, CurSubF, CurCat, True);
            if not ExtendedIndex then
              IndexThisTopic := False; {'cause this topic is indexed in INT XX}
          end;

          if  (Copy (StrUp, 1, 5) = 'CMOS ')
          and (StrUp [6] in HexChars) and (StrUp [7] in HexChars)
          and (StrUp [8] = 'H') then begin
            if  (StrUp [9] = '-')
            and (StrUp [10] in HexChars) and (StrUp [11] in HexChars)
            and (StrUp [12] = 'H') then
              ExtendedHeader := Copy (Str, 13, Length (Str) - 12)
            else
              ExtendedHeader := Copy (Str, 9, Length (Str) - 8);

            ExtendedHeader := #2 + TopicName + #2 + ExtendedHeader;
          end;

          if  (Copy (StrUp, 1, 5) = 'CALL ')
          and (StrUp [6] in HexChars + ['X']) and (StrUp [7] in HexChars + ['X'])
          and (StrUp [8] in HexChars + ['X']) and (StrUp [9] in HexChars + ['X'])
          and (StrUp [10] = 'H')
          and (StrUp [11] = ':')
          and (StrUp [12] in HexChars + ['X']) and (StrUp [13] in HexChars + ['X'])
          and (StrUp [14] in HexChars + ['X']) and (StrUp [15] in HexChars + ['X'])
          and (StrUp [16] = 'H')
          then begin
            ExtendedHeader := #2 + TopicName + #2
                            + Copy (Str, 17, Length (Str) - 16);
          end;

          if  (Copy (StrUp, 1, 4) = 'MEM ')
          and (StrUp [5] in HexChars + ['X']) and (StrUp [6] in HexChars + ['X'])
          and (StrUp [7] in HexChars + ['X']) and (StrUp [8] in HexChars + ['X'])
          then
            if  (StrUp [9] = 'H')
            and (StrUp [10] = ':')
            and (StrUp [11] in HexChars + ['X']) and (StrUp [12] in HexChars + ['X'])
            and (StrUp [13] in HexChars + ['X']) and (StrUp [14] in HexChars + ['X'])
            and (StrUp [15] = 'H')
            then
              ExtendedHeader := #2 + TopicName + #2
                              + Copy (Str, 16, Length (Str) - 15)
            else
            if  (StrUp  [9] in HexChars + ['X']) and (StrUp [10] in HexChars + ['X'])
            and (StrUp [11] in HexChars + ['X']) and (StrUp [12] in HexChars + ['X'])
            and (StrUp [13] = 'H')
            then
              ExtendedHeader := #2 + TopicName + #2
                              + Copy (Str, 14, Length (Str) - 13);

          if  (Copy (StrUp, 1, 5) = 'PORT ')
          and (StrUp [6] in HexChars) and (StrUp [7] in HexChars)
          and (StrUp [8] in HexChars) and (StrUp [9] in HexChars)
          then begin
            if  (StrUp [10] = '-')
            and (StrUp [11] in HexChars + ['?']) and (StrUp [12] in HexChars + ['?'])
            and (StrUp [13] in HexChars + ['?']) and (StrUp [14] in HexChars + ['?', 'x', ' '])
            then
              ExtendedHeader := Copy (Str, 15, Length (Str) - 14)
            else
              ExtendedHeader := Copy (Str, 10, Length (Str) - 9);

            ExtendedHeader := #2 + TopicName + #2 + ExtendedHeader;
          end;

          if KeyNames. Count > 0 then
            for I := 0 to KeyNames. Count - 1 do begin
              J := Pos (StUpcase2 (PString32 (KeyNames. At (I))^), StrUp);
              if  (J > 0)
              and ((PTopic (KeyLists. At (I))^. Count = 0)
                or (PString (PTopic (KeyLists. At (I))^. At (
                    PTopic (KeyLists. At (I))^. Count - 1))^
                 <> ' ' + ExtendedHeader))
              then begin
                PTopic (KeyLists. Items^ [I])^.AddKeyword (OriginalTopicName, 0);
                AddStr2Topic (ExtendedHeader,
                              PTopic (KeyLists. Items^ [I]),
                              PString (KeyNames. At (I))^, CurInt, CurSubF, CurCat, True);
              end;
            end;

          I := Pos ('TABLE', StrUp);
          if  (I > 0) and (I + 9 <= Length (Str))
          and (Str [I + 6] in ['0'..'9', 'C', 'F', 'M', 'P'])
          and (Str [I + 7] in ['0'..'9'])
          and (Str [I + 8] in ['0'..'9'])
          and (Str [I + 9] in ['0'..'9'])
          then begin
            if not TblClosed then begin
              PrevStr := TblTopic^.At (TblTopic^.Count - 1);
              if (PrevStr <> nil) and (PrevStr^ <> '') and (PrevStr^ <> ' ') then begin
                TblTopic^. AtDelete (TblTopic^.Count - 1);
                if PrevStr <> nil then begin
                  J := Pos (#2, PrevStr^);
                  while J > 0 do begin
                    SavePtr := PrevStr;
                    PrevStr := NewStr (Copy (PrevStr^, 1, J - 1)
                               + Copy (PrevStr^, J + 1, Length (PrevStr^) - J));
                    DisposeStr (SavePtr);
                    J := Pos (#2, PrevStr^);
                    if J = 0 then
                      WriteLn ('error 5');
                    SavePtr := PrevStr;
                    PrevStr := NewStr (Copy (PrevStr^, 1, J - 1)
                               + Copy (PrevStr^, J + 1, Length (PrevStr^) - J));
                    DisposeStr (SavePtr);
                    TblTopic^. Keywords. AtFree (TblTopic^. Keywords. Count - 1);
                    J := Pos (#2, PrevStr^);
                  end;
                end;
              end else
                PrevStr := nil;

              TblTopic^.AddKeyword (OriginalTopicName, 0);
              AddStr2Topic (ExtendedHeader, TblTopic, TblTopicName, CurInt, CurSubF, CurCat, False);
              FO. IdxTbl. Insert (New (PIndexEntry, Init (
                TblTopicName, '', 0, TblTopic, False)));
              TblStarted := False;
              TblClosed := True;
            end else begin
              PrevStr := Topic^.At (Topic^.Count - 1);
              if (PrevStr <> nil) and (PrevStr^ <> '') and (PrevStr^ <> ' ') then begin
                Topic^. AtDelete (Topic^.Count - 1);
                if PrevStr <> nil then begin
                  J := Pos (#2, PrevStr^);
                  while J > 0 do begin
                    SavePtr := PrevStr;
                    PrevStr := NewStr (Copy (PrevStr^, 1, J - 1)
                               + Copy (PrevStr^, J + 1, Length (PrevStr^) - J));
                    DisposeStr (SavePtr);
                    J := Pos (#2, PrevStr^);
                    if J = 0 then
                      WriteLn ('error 5');
                    SavePtr := PrevStr;
                    PrevStr := NewStr (Copy (PrevStr^, 1, J - 1)
                               + Copy (PrevStr^, J + 1, Length (PrevStr^) - J));
                    DisposeStr (SavePtr);
                    Topic^. Keywords. AtFree (Topic^. Keywords. Count - 1);
                    J := Pos (#2, PrevStr^);
                  end;
                end;
              end else
                PrevStr := nil;
            end;

            New (TblTopic, Init (1, 1));
            TblStarted := True;
            TblClosed := False;
            TblTopicName := MakeCorrectTopicName ('#' + Copy (Str, I + 6, 4));

            if (PrevStr <> nil) and (PrevStr^ <> '') and (PrevStr^ <> ' ')
            then begin
              if Pos (#2, PrevStr^) > 0 then begin
                WriteLn (PrevStr^);
                WriteLn ('error 4');
              end;
              AddStr2Topic (PrevStr^, TblTopic, TblTopicName, CurInt, CurSubF, CurCat, False);

              AddStr2Topic (TblTopicName + PrevStr^, Topic, TopicName, CurInt, CurSubF, CurCat, True);
              Tables^.AddKeyword (TopicName, 0);
              AddStr2Topic (TblTopicName + ' '#2 + TopicName + #2
                          + PrevStr^, Tables, TablesName, CurInt, CurSubF, CurCat, True);
            end else
              AddNextStringToTopicAsATblRef := True;
            DisposeStr (PrevStr);

            AddStr2Topic (Str, TblTopic, TblTopicName, CurInt, CurSubF, CurCat, False);
          end else begin
            if TblStarted then begin
              if AddNextStringToTopicAsATblRef then begin
                AddStr2Topic (TblTopicName + ' ' + Str, Topic, TopicName, CurInt, CurSubF, CurCat, True);
                Tables^.AddKeyword (TopicName, 0);
                AddStr2Topic (TblTopicName + ' '#2 + TopicName + #2
                            + ' ' + Str, Tables, TablesName, CurInt, CurSubF, CurCat, True);
                AddNextStringToTopicAsATblRef := False;
              end;

              AddStr2Topic (Str, TblTopic, TblTopicName, CurInt, CurSubF, CurCat, False);
            end;
          end;

          if not TblStarted then
            AddStr2Topic (Str, Topic, TopicName, CurInt, CurSubF, CurCat, True);
        end;
      end;
    end;

    if not TblClosed then begin
      TblTopic^.AddKeyword (OriginalTopicName, 0);
      AddStr2Topic (ExtendedHeader, TblTopic, TblTopicName, CurInt, CurSubF, CurCat, False);
      FO. IdxTbl. Insert (New (PIndexEntry, Init (
        TblTopicName, '', 0, TblTopic, False)));
      TblStarted := False;
      TblClosed := True;
    end;

    if not SectionClosed then begin
      if Pos ('CMOS', StUpcase2 (FileName)) > 0 then begin
        CMOS^.AddKeyword (OriginalTopicName, 0);
        AddStr2Topic (ExtendedHeader,
                      CMOS, CMOSName, CurInt, CurSubF, CurCat, True);
      end else
      if Pos ('FARCALL', StUpcase2 (FileName)) > 0 then begin
        FarCall^.AddKeyword (OriginalTopicName, 0);
        AddStr2Topic (ExtendedHeader,
                      FarCall, FarCallName, CurInt, CurSubF, CurCat, True);
      end else
      if Pos ('MEMORY', StUpcase2 (FileName)) > 0 then begin
        Memory^.AddKeyword (OriginalTopicName, 0);
        AddStr2Topic (ExtendedHeader,
                      Memory, MemoryName, CurInt, CurSubF, CurCat, True);
      end else
      if Pos ('PORTS', StUpcase2 (FileName)) > 0 then begin
        Ports^.AddKeyword (OriginalTopicName, 0);
        AddStr2Topic (ExtendedHeader,
                      Ports, PortsName, CurInt, CurSubF, CurCat, True);
      end else
      if  (FileIsATopic = '')
      and ((not (ExtendedHeader [2] in HexChars))
        or (not (ExtendedHeader [3] in HexChars)))
      then begin
        IntList^.AddKeyword (OriginalTopicName, 0);
        AddStr2Topic (ExtendedHeader,
                      IntList, IntListName, CurInt, CurSubF, CurCat, True);
      end;

      FO. IdxTbl. Insert (New (PIndexEntry, Init (
        TopicName, '', 0, Topic, IndexThisTopic)));
      IndexThisTopic := True;
      SectionClosed := True;
    end;

    Close (FI);
  end else
    ProcessInterrup := False;
end;

var
  Param: string;
  C: Char;
  T: PTopic;
  I: Integer;
  KeyFile: Text;
  KeyStr: string;
  PKeyStr: PString32;

  SwapFileSize: Longint;

  F: file;

begin
  WriteLn;
  WriteLn ('=== Int2TPH Interrupt List Compiler v0.9 Copyright (C) 1996 Slava Gostrenko ===');
  WriteLn;

  for I := 1 to ParamCount do begin
    Param := StUpcase2 (ParamStr (I));
    if Param [1] in ['/', '\', '-'] then
      if Pos ('SHORTINDEX', Param) = 2 then
        ExtendedIndex := False
      else
      if Param [2] in ['?', 'H'] then begin
        WriteLn ('Converts Ralf Brown''s Interrupt List into Borland Turbo Help File (.TPH).');
        WriteLn;
        WriteLn ('Usage:   Int2TPH [options]');
        WriteLn ('Options: /ShortIndex  -  generate a shorter index to make it possible');
        WriteLn ('         to use the resulting help file with the Turbo Help resident.');
        Exit;
      end;
  end;

  SwapFileSize := Longint (4096)*1024 - MemAvail;
  if SwapFileSize > 0 then
    SwapFileSize := SwapFileSize and (-1024)
  else
    SwapFileSize := 0;
  if SwapFileSize > 0 then begin
    MemInitSwapFile ('int2tph.swp', SwapFileSize);
    WriteLn ('swap file size - ', SwapFileSize);
  end;

  New (SwapFile, Init ('topics.swp', stCreate, 2048));

  Hdrs. Init (256, 256);

  FO. Init ('inter.tph', stCreate, 32768);
  Assign (IncompPattern, 'incomplt.log');
  Rewrite (IncompPattern);

  New (T, Init (1, 1));
  T^. AddString ('The first topic will be never seen');
  FO. IdxTbl. Insert (New (PIndexEntry, Init (
      '', '', 0, T, False)));

  New (T, Init (16, 16));
  T^. AddString ('Visit the home page of Slava Gostrenko at http://sunny.aha.ru/~gw/');
  T^. AddString (' ');
  T^. AddString ('There you may check for the latest versions of Int2TPH and other software.');
  T^. AddString (' ');
  T^. AddString ('=== ARVID AUDIO ===');
  T^. AddString (' ');
  T^. AddString ('is a CD quality digital audio tape recorder made of Sound Blaster sound card');
  T^. AddString ('and  Arvid  streamer  board.  Arvid is a PC board priced at as little as $70');
  T^. AddString ('that  makes  a  streamer  of your home video tape recorder. It is capable of');
  T^. AddString ('storing  2  GigaBytes of data on a single tape. With the help of Arvid Audio');
  T^. AddString ('software you may record 3 hours of digital audio sound on a regular 180 min.');
  T^. AddString ('videotape.  Arvid  Audio  records from all audio sources available on(via) a');
  T^. AddString ('Sound Blaster sound card, e.i. CD player, Microphone, Line In. And now it is');
  T^. AddString ('capable  of  Direct  Digital R r)ic, Ke#2
 ik. AddSeLine In. Ando aeLn r FO. Initr
       AF, CurCat, T^. AddStD     oa oLtu ref fron(al audis)ic, KpAln. And now it is');
  T^'#3sPattern (Stru       eb eru     s of  Diat, T^.nWog o1owital a> ' ') then begin
                Topv. Andoopic, Init (1, 1));
      SectionStarted := True;
      T );

rUp [8] in HexCharVs4ppt, True) );

rUp [8bepr;   ep [8beps    s o, 1));
n^   d.  grabbddSt;

. A advanamerjipic  crevStrion board priced at as littlgor

mt (1, 1));
      SectionStarted := True;
      T )BORLAND PASCAL AUTO CORRECTORUp [8] in HexCharVs4ppt, True) );

rUp [8bepr;   ep [8beprogram
   pable of');g o1uch easic  to edg og ('sprogram, 1,teLn ('Ue) );

rUp [8bepr;   Pascal  Wr IDE. U  Tblexp('ULn r ditrion.3] BP Auto PrevStror beautifif')g ('audio sound on a regular d card    cord fly. Type "tmysuperobjStr". Andlookr  oord screen. Y(al audis)ic, KpAln. And now isee "TMySuperObjStr" R r)in(aldoleNamhave to press shift keypy ( f Ch such Microphone, Line In. Andnice  Longiifif
   Autoeywo  featS <>it (
unglueng ('st An'Sound <F2> keyt (1, 1));
      SectioV DiaSubst  featS <>it (
enLn r eLn ('UsPascal  WrIDEy ( work 1,tg  2  cCou
 ik. AddSeLine In. AndoARVIDs
   pn 80x25. And80x50. Nown.');
  ue;
upng ('sBPy ( work 1,tany textaudio sources available on(v icCoun   pablep [suppuse d  byng ('s on(v cStrinY');
      VESAs on(vaudio sources availablecCou

   otendedenjoy cCou
d;

  SwreDR dotrinupn ( 132x60! Auto PrevStrore) );

rUp [8bepr;   encluou

 patchu

     BPy ( ng he recal full screen edg    ;

n( nenu ('Ue) );

rUp [8bepr;   statu

 lineAt (I neans 2      lineAit (
   uInte    disapabpr; g ('sr d cao tape recorder. It is cex At BP Auto PrevStror is dis. Ibue d ;

r d ca texts! (1, 1));
      SectionStarted := True;
      T )TICKTOSS digital audio tape recorder made of Sound Blaster soundopicecho

   or     end-uInr  idonet sysI))^. TickToss is justund.bataudio sources availableopic.  No  .exe  Wr     .com  W.  But;g ohas Blasord featS <s. A end-uInr   ''icrophone, Line In. Andnee= Posutomatic cte (;

 oNo  Aopicecho
d;

 eans. Aful diStror y n
   crophone, Line In. Andnte (IAudiole asupd(IAudioNoae (
  figur(;

 pic.  te (IAudile aupd(IAudioNudio sources availableopic.s.bbs Wr  in g ('sropicecho
 oae (.  BSppuse      B loudiom    ineAdopiceudio sources availableodescrie');
 or ggAudioNoper   mer  c');
 or)inlasord fabovelhar;dfeatS <s.board priced at as littl  Tomplemenr;dfs Blftware ybata pic.  ickToss irequi<s. 4do     st taitabceudio sources availableost mle a

   or ');
  T^. AddString (' ');
  T^. AddString ('is a Ce aMORE...digital audio tape recorder made of Sound Blaster sWog o1owital      NOW! ;-)tal audio tape recorder made ofalse)));

  New (T, Init (16, 16));
  T^. AddString ('There you may check f ('Visit thenit (page of S (I));
 Low((T22s. At) ( nHigh((T22s. At) in ['/', '\', , InirCat, True);
trenko at http://sugenerxtendedIn   if (PrevStr <> nil) and Chars +alToT^. ORTINDEX', Hdrs. Init (25rCat, T (16,
trenko at http://surCat, T (16,       if (PrevStr <> nil) and OS 'ERRUPT LIST 
    made ofrCat, T (16,dHead recorder s a c :=opy d;
  end;
as st tend ;

rrrrigital audrCat, T (16,dHead recorder s a ring ('= I :=mCount do begin
    Par.rigital audrCat, T (16,dHeader,
    ng ('There you may check f (0al audrCat, T (16,dHead recorder s a onstg ('There you may check fnst    gw@ may c,rigital audrCat, T (16,dHead recorder s a FidoNet 2:5020/201.105,2:5020/468.105.rigital audrCat, T (16,dHead recorder tal audrCat, T (16,dHeader,
    nTITLESf (0al audrCat, T (16,dHead recorder fnstteLn;
  sdTopicName,ames. At (I);
  FO. int;

;
    I);
  FO. int;


  NeileSize, 1))t_eypy.ttaudio sorrup := True;
 ileSizedio sorru+}riteLn ('processing ', FileName, '  Length (Str) > ileSized
      and (FileIsATopic ileSize, in
  (4096)*102Delete (Topin
  ( >nHigh((gin
  ^ - 12)
        File, Initloudieyp, stCrin
  (WriteLn ('Converts RCount - --------', Topic, TopicName, CurdHeader))
   New (TdHeader))
m [1],it (25PTblClosed := False; then
       t (25Pin
  (4096)*102\', 'in
  ^   if (PrevStr <> nil) andin
  (4096)*102\', end;
        New (TdHeng32 (KeyNam, Pin
  (409e;
        enat, T (16,dHeader,
    'in
  ^me + #2
        rCat, T (16,dHead recorder fns    in
  ^ CurI begin
      TblTopic
end;

var
  ParileSizedio so Hdrs. Init (25rCat, T
trenko at http://surCat, T       if (PrevStr <> nil) and teLn;
        Misc. Stufftal audrCat, T (16,dHeader,
    O. IdxTbl. In0al audrCat, T (16,dHead recorder fns CurCat, T     CurI begof Slava G AddNextrenko at http://sunStringToT   if (PrevStr <> nil) and nStrintal audrCat, T (16,dHeader,
    tStringToTop0al audrCat, T (16,dHead recorder fns CunStringToT CurI begof Slava     iftrenko at http://su Pos ('F   if (PrevStr <> nil) and rd (Oal audrCat, T (16,dHeader,
     Pos ('FAR0al audrCat, T (16,dHead recorder fns Cu Pos ('F CurI begof Slava se
     trenko at http://su if Pos ('M   if (PrevStr <> nil) and  if elsental audrCat, T (16,dHeader,
     if Pos ('MEM0al audrCat, T (16,dHead recorder fns Cu if Pos ('M CurI begof Slava 
      trenko at http://suif Pos ('P   if (PrevStr <> nil) and if Postal audrCat, T (16,dHeader,
    if Pos ('POR0al audrCat, T (16,dHead recorder fns Cuif Pos ('P CurI begof Slava       itrenko at http://su    s ('F   if (PrevStr <> nil) and      tal audrCat, T (16,dHeader,
    f  (FileIsA0al audrCat, T (16,dHead recorder fns Cuf  (FileI CurI begof S): Boolean;
typelog');
ty.1stf ('Vp://su : Boolean;
typeleger of
.keyf ('Vp://su : Boolean;
RUypel86bugs.lstf ('86 Bugstal audrCat, T (16,dHeader,
    n86 Bugst (0al audrCat, T (16,dHead recorder fnst86 BugstrI begin : Boolean;
typelbiblio.lstf ('Vp://su : Boolean;
typelemos.lstf ('Vp://su : Boolean;
typelfarcall.lstf ('Vp://su : Boolean;
typelglossary.lstf ('GlossaryioNoIndeteLn;
       tal audrCat, T (16,dHeader,
    nGlossaryioNoIndeteLn;
       t (0al audrCat, T (16,dHead recorder fnstGlossaryioNoIndeteLn;
       trI begin : Boolean;
typelmf Pos.lstf ('Vp://su : Boolean;
typelopcou
d.lstf ('Opcou
d     tal audrCat, T (16,dHeader,
    nOpcou
d     t (0al audrCat, T (16,dHead recorder fnstOpcou
d     trI begin : Boolean;
typeloverview.lstf ('Vp://su : Boolean;
typeluse s.lstf ('Vp://su : Boolean;
typeltabces.lstf ('Vp://su : Boolean;
typelog');
ty.prif ('teLn;
   Prim'icrophonrCat, T (16,dHeader,
    nteLn;
   Prim'ic (0al audrCat, T (16,dHead recorder fnstteLn;
   Prim'icrI begin : Boolean;
typelrb    .ttau (';
        rophonrCat, T (16,dHeader,
    n;
         (0al audrCat, T (16,dHead recorder fnst;
        rI begof SileName : Boolean;
typelog');
ty.lstf ('Vp02\', end;
ean;
ader,
    if Pos ('POR0al audrCatme : h', In'z'  StrUp := lstf ('Vp02\', end;
ean;
ader,
   ')
 Pos ('POR0al auuuuuBreak (IncompPatt  T^. AddString ('There you may check f ('Visd recorder ow((T22F   if At) ( nHigh((TpPatt  T^. AddString ('There you may check f ('Visad recorder ow((T22('P   ifAt) ( nHigh((TpPatt  T^. AddString ('There you may check f ('Visead recorder ow((T22s ('M   iAt) ( nHigh((TpPatt  T^. AddString ('There you may check f ('Vis recorder ow((T22  if (At) ( nHigh((TpPatt  T^. AddString ('There you may check f ('Visad recorder ow((T22sFalse;
t) ( nHigh((TpPatt  T^. AddString ('There you may check f ('Visead recorder ow((T22T       i
t) ( nHigh((T CurdHalse; then
eSize > 0 then t (I))^), StrUp);alse; then
e   if )));
      IndexThisTopic := True;
      SectionClosed := Trsts. At (I))^. Count = 0)
  r ow((T22FSubF, CurCat, True);
       
t) ( nHigh((TpPatt  T^. AddString ('There you may check f ('Visead recd OS 'ERRr ow((T22T      (16,   At) ( nHigh((T22s. At) in ['/', '\', , InirCat, True);
tre ('Vise   IndexThisTopic := True;
      SectionClosed :=  and Chars +r ow((T22T      ars +r At) ( nHigh((T5rCat,   FO. IdxTbl. Insise   Don    CurIteLn ('Coplt.lo, T (16'se)));s');
  Ted AddStriplt.loDon    CurI', stCre^.Seek (fnst;
', stCre^.Trun
RUyst;
at, Falph', stCreatDon taudio so