%
% "mortgage.t" generate listing of monthly mortgage
% principle and interest
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

program

    var balance, f,
        payment, i,
        interest_rate,
        interest,
        principle : real
    var years, month, n : int
        
    prompt "loan amount $"
    get balance
    put "loan    = $", balance:2

    prompt "interest rate %"
    get interest_rate
    put "apr     = ", interest_rate, "%"
    prompt "years to pay"
    get years
    put "term    = ", years * 12, " months"

    i := interest_rate / 1200
    n := years * 12
    f := balance * i * ( 1 + i )^n / ( ( 1 + i )^n - 1 )
    payment := 0.01 * ceil( 100 * f )
    put "payment = $", payment:2
    put ""
    put "  #   principle    interest     balance"
    put "---------------------------------------"
    n := 0
    loop

        incr n
        interest := 0.01 * round( 100 * balance * i )
        principle := payment - interest
        balance := balance + interest - payment
        put n:3, principle:12:2, interest:12:2, balance:12:2

        exit when balance <= 0.0

    end loop

end program