{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; presentation of virtual screens with effects #2

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBSCR;


const Methods    : array [1 .. 6] of PresentationMethodType
                 = (Explode, Shrink, Fade, Push, Sweep, Float);
      Directions : array [1 .. 4] of DirectionType
                 = (Leftward, Rightward, Upward, Downward);
      Speed      = 6; { Delay between presentation moves }

var MyVirtualScreen : VirtualScreenObjecttype;
    MyBox : BoxObjectType; Index1, Index2 : word;

begin
     Screen.Draw;

     with MyVirtualScreen do begin
          InitializeRegion (1, 1, 80, 25);
          { Draw some graphics in the virtual screen }
          Fill (#177, Blue);
          DrawLine (1, 1, 80, 25, #177, LightCyan + Blue * 16);
          DrawLine (1, 25, 80, 1, #177, LightCyan + Blue * 16);

          { Present the graphics using all possible presentation methods
            in all directions }
          for Index1 := 1 to SizeOf(Methods) do
              for Index2 := 1 to SizeOf(Directions) do
                  if (Index1 > 3) or (Index2 = 1) then with MyBox do begin
                     { Create a box on the physical screen }
                     InitializeBox (9, 2, 71, 24, DoubleBorder);
                     DrawLine (10, 3, 70, 23, #219, 14);
                     DrawLine (10, 23, 70, 3, #219, 14);

                     { Present an area of the virtual screen }
                     PresentArea (10, 3, 70, 23,      { Field to present }
                                  10, 3,              { Where to present it }
                                  Methods[Index1],    { Presentation method }
                                  Directions[Index2], { Movement direction }
                                  Speed);             { Delay between moves
                                                        in milliseconds }
                     Intercept; { Box }
                end;
          Intercept;
     end;
end.
