{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; stacks #1

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBBAS, EFLIBOBJ, EFLIBWIN, EFLIBDAT, EFLIBTXT,
     EFLIBKBD;

var MyWindow : WindowObjectType;
    MyStack : StackObjectType; Data : string[63]; Index : word;
    NumberOfElements : word; StartMemory, MemoryUsed : longint; DataFlow : real;
    RunTimer : TimerObjectType; Intact : boolean;


begin
     StartMemory := MemAvail; RunTimer.Initialize;

     RandSeed := 0; { Control random seed }

     with MyWindow do begin
          InitializeWindow (1, 1, 80, 25, 'EFLIB', NoBorder, FALSE, FALSE);
          SetTextCoordinates (4, 4, 77, 24);

          WriteLn ('@C@@LightGreen:Blue@* Stacks *');
          WriteLn ('@C@@White:Blue@All data types have many common features. Stacks are');
          WriteLn ('@C@useful when dealing with recursive problems.');
          WriteLn ('@Yellow:Blue@'); LineFeed;


          RunTimer.Reset;

          { Build queue }
          WriteLn ('@LightRed:Blue@');
          WriteLn ('Building a stack (adding as many element as memory can keep) ...');

          MyStack.InitializeStack (SizeOf(Data), { Element size }
                                   TRUE); { Skip extra safety checkings }

          NumberOfElements := 0;
          while MyStack.IsFree and not GlobalDataError do begin
                Inc (NumberOfElements);
                Data := StringGeneratedRandomly (Pred(SizeOf(Data)));
                MyStack.Push (Data);
          end;

          MemoryUsed := (StartMemory - MemAvail);

          WriteLn ('@Yellow:Blue@Pops all elements from the stack ... ');
          for Index := 1 to NumberOfElements do MyStack.Pop (Data);

          WriteLn ('@LightGreen:Blue@Done.');
          WriteLn ('');
          WriteLn ('');

          Intact := MyStack.IsIntact;

          { Intercept object (and dispose all elements from the heap) }
          MyStack.Intercept;

          DataFlow := (MemoryUsed / (1 + RunTimer.ElapsedMS)) * 1e3;

          WriteLn ('@White:Blue@DATA FLOW ANALYZIS');
          WriteLn ('@Yellow:Blue@Builded '+StringNumber(NumberOfElements, 0, 0)+' elements at '+
                   StringNumber(RunTimer.ElapsedMS, 0, 0)+' ms, with an average data flow of '+
                   StringNumber(DataFlow, 0, 0));
          WriteLn ('byte per second and a total data allocation of '+StringNumber(MemoryUsed, 0, 0)+' bytes.');
          WriteLn ('');

          WriteLn ('@White:Blue@');
          WriteLn ('[Intact]  :  ' + StringBoolean (Intact));
          WriteLn ('[Errors]  :  ' + StringBoolean (GlobalErrorFlag or GlobalDataError));

          repeat until Keyboard.KeyPressed;

          Intercept;
     end;
end.