{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; Newton-Raphsons method for iterative equation solving

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBMTH;


const Iterations = 1000; { Number of iterations -
                           larger value gives better precision in results }

{ Returns y(x) there y is the function that should be solved; y(x) = 0; x = ? }
function FunctionProc (X : real) : real; far;
begin
     FunctionProc := PowerNumber (X, 3) + X - 3;
end;

{ Returns y'(x) there y is the function that should be solved }
function DerivateProc (X : real) : real; far;
begin
     DerivateProc := 3 * PowerNumber (X, 2) + 1;
end;


var Result : real;

begin
     { Newton-Raphsons method with algebratic derivate specified in function }
     NewtonRaphsonsMethod (1, Iterations, Result, @FunctionProc, @DerivateProc);
     WriteLn ('Newton-Raphsons method (algebrathic derivate)':45,' : ', Result:10:10);

     { Newton-Raphsons method with approximated derivate }
     NewtonRaphsonsMethodDA (1, Iterations, 0.001, Result, @FunctionProc);
     WriteLn ('(approximated derivate)':45,' : ', Result:10:10);

     WriteLn;
end.