{ Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; priority queue implemented as a heap

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBDAT;

const NumberOfElements = 20;

var PriorityQueue : PriorityQueueObjectType;
    Number        : byte;
    Index         : byte;


begin
     Randomize;

     WriteLn ('* Priority queue based on a heap with dynamic allocation *');

     with PriorityQueue do begin
          Initialize (NumberOfElements, SizeOf(Number));

          SetKey (1, SizeOf(Number));

          for Index := 1 to NumberOfElements do begin
              Number := Succ(Random(High(Number)));
              Store (Number);
          end;

          { When elements are retrieved from a priority queue, the biggest
            element is always the first to be retrieved. By creating your
            own priority queue object and override the Compare method, you
            can change the order of the priority queue. You must override
            this method if your element data don't support byte-wise
            comparison (variables such as words or integers doesn't). If you
            want just a region of the element to be compared, set the key
            region with the SetKey method. }

          while not IsEmpty do begin
                Retrieve (Number);
                Write (Number, ' ');
          end;

          WriteLn;

          Intercept;
     end;

     if GlobalDataError then WriteLn ('Error(s) reported!');
end.