 { Borland Pascal Extended Function Library - EFLIB (C) Johan Larsson, 1996
  Demonstration; storage of objects in streams

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE COPIED, SOLD OR
  MANIPULATED. FOR MORE INFORMATION, SEE PROGRAM MANUAL! THIS DEMONSTRAT-
  ION PROGRAM MAY FREELY BE USED AND DISTRIBUTED.                          }


uses EFLIBDEF, EFLIBINI, EFLIBDAT, EFLIBIO, EFLIBBAS;


var MyStructure : TextObjectPointerType;
    MyObject    : ObjectPointerType;
    MyStream    : FileStreamObjectType;
    Data        : string;

begin
     { Initialize data structure (can be of any type that supports
       stream storage) }
     New (MyStructure, Initialize);

     with MyStructure^ do begin
          Data := 'Stream storage makes it very easy to transfer objects'; Add (Data);
          Data := 'to a file or to a memory allocation, and then reconstruct'; Add (Data);
          Data := 'the entire object later.'; Add (Data);

          with MyStream do begin
               Initialize ('TEMP.$$$', 1024); Create;
               WriteLn ('* Stores object to stream *');
               Store (MyStructure);
               { Read object from stream }
               Seek (0);
               WriteLn ('* Loads object to stream *');
               Load (MyObject);
               Intercept; { Stream }
          end;

          if MyObject^.IsInitialized and (MyStructure^.IsEqual(MyObject)) then
             with StructureObjectPointerType(MyObject)^ do begin
                  { Write the objects type name }
                  WriteLn ('This object is of the type ', NameOfType, '.');
                  WriteLn ('* Content *');
                  { Construct an iterator for the data type }
                  with CreateIterator^ do begin
                       repeat
                             { Display element contents }
                             WriteLn (String(Content^));
                             WalkForward; { Go to next element }
                       until IsEnd;
                       Free; { Iterator }
                  end;
                  Free; { My object }
          end else WriteLn ('* Failed to reconstruct object! *');

          MyStructure^.Free;

          WriteLn ('* Done *');
     end;

     DeleteFile ('TEMP.$$$'); { Delete temporary test file }
end.