#include "windows.h"
#include "windowsx.h"

#define WM_MOUSEMOVEIN     WM_USER+1
#define WM_MOUSEMOVEOUT    WM_USER+2

BOOL CALLBACK DialogProc(HWND, UINT, WPARAM, LPARAM);
void MyDispatchMessage(MSG FAR *);

HWND    hwnd        = NULL;
static  bMouseIn    = FALSE;

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    hwnd = CreateDialog(hInstance, "MainDialog",
        NULL, DialogProc);
    if (!hwnd)
        return (FALSE);
    ShowWindow(hwnd, nCmdShow);
    UpdateWindow(hwnd);
    return TRUE;
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hInstance,
    HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;
    POINT pt;

    if (!InitInstance(hInstance, nCmdShow))
        {
        MessageBox(NULL, "InitApp Failed", NULL, MB_OK);
        return (FALSE);
        }
    GetCursorPos(&pt);
    bMouseIn = WindowFromPoint(pt) == hwnd;

    while(GetMessage(&msg, 0, 0, 0))
        {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
        MyDispatchMessage(&msg);
        }
    return (msg.wParam);
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
static BOOL DialogCommand(HWND Dialog, int ControlId,
    HWND Control, UINT Notify)
    {
    if(ControlId == IDOK || ControlId == IDCANCEL)
        {
        DestroyWindow(Dialog);
        PostQuitMessage(0);
        }
    return FALSE;
    }

BOOL CALLBACK DialogProc(HWND Dialog, UINT message,
        WPARAM wParam, LPARAM lParam)
{
    switch (message)
        {
        case WM_MOUSEMOVEIN     :
            SetDlgItemText(Dialog, 101, "Mouse Entered");
            break;
        case WM_MOUSEMOVEOUT    :
            SetDlgItemText(Dialog, 101, "Mouse Left");
            break;
        HANDLE_MSG(Dialog, WM_COMMAND, DialogCommand);
        }
    return FALSE;
}

void MyDispatchMessage(MSG FAR* pmsg)
{
    //If mouse is in then check if it has gone out. If
    //mouse is not in then check if it has come in.
    if(bMouseIn)
        {
        //As long as there is no message for this application
        //track the mouse cursor position.
        while(!PeekMessage(pmsg, 0, 0, 0, PM_NOREMOVE))
            {
            POINT pt;
            HWND hwndBuf;

            GetCursorPos(&pt);

            hwndBuf = WindowFromPoint(pt);

            //If window at mouse cursor position is not this
            //app's window and not any of its child windows
            //then it means mouse has left the app area.
            if(hwndBuf != hwnd && !IsChild(hwnd, hwndBuf))
                {
                bMouseIn = FALSE;
                PostMessage(hwnd, WM_MOUSEMOVEOUT, 0, 0L);
                }
            }
        }
    else
        {
        //If the mouse is not in and the app has received
        //mouse move message the it means mouse has entered.
        if(pmsg->message == WM_MOUSEMOVE ||
            pmsg->message == WM_NCMOUSEMOVE)
            {
            bMouseIn = TRUE;
            PostMessage(hwnd, WM_MOUSEMOVEIN, 0, 0L);
            }
        }
}
