
#include <windows.h>
#include <stdio.h>

#define A 0
#define B 1

DWORD ThreadProc_A(PVOID);
DWORD ThreadProc_B(PVOID);

HANDLE hEvent = NULL;
CHAR   gChar = 0x0;

VOID main(int argc, char **argv)
{
    HANDLE hThread[2];
    DWORD  ThreadID;

    hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);

    hThread[A] = CreateThread(NULL, 0, ThreadProc_A,
        NULL, CREATE_SUSPENDED, &ThreadID);

    hThread[B] = CreateThread(NULL, 0, ThreadProc_B,
        NULL, CREATE_SUSPENDED, &ThreadID);

    ResumeThread(hThread[A]);
    ResumeThread(hThread[B]);

    WaitForMultipleObjects(2, hThread, TRUE, INFINITE);
    printf("Last thread to finish was %c\n", gChar);
    return;
}

DWORD ThreadProc_A(PVOID Param)
{
    WaitForSingleObject(hEvent, INFINITE);
    gChar = 'A';
    OutputDebugString("ThreadProc_A");
    return TRUE;
}

DWORD ThreadProc_B(PVOID Param)
{
    SetEvent(hEvent);
    gChar = 'B';
    OutputDebugString("ThreadProc_B");
    return TRUE;
}



