'RAW100.BAS
'
'RAW file converter 1.00 -- written by Lloyd Chang
'
'purpose: Converts a 24 bit (truecolor) RAW file
'         into a 8 bit (256 colors) RAW file
'         with the RGB palette created by RGB100.BAS
'             
'lingo: 24 bit = 16,400,000 (16.4 million)
'       8 bit = 256
'       RAW file = A file without a header.
'                  It contains only data.
'
'note: 24 bit RAW file uses 3 bytes per pixel.
'      Each byte of the 3 bytes contains either
'      the red, green, or blue component of the pixel.
'
'note: 8 bit RAW file uses 1 byte per pixel.
'      Therefore, it requires a palette to properly
'      display the colors.  In RAW-256.BAS, the RGB
'      palette created by RGB100.BAS is used.
'
'note: Scaling is not supported.
'
'note: Color dithering is not supported either.
'
'note: The user of this program has to know the
'      horizontal and vertical size of the 24 bit
'      RAW file beforehand.
'
'note: An error might occur when this program is
'      used in the QuickBasic Environment.
'      Try using RAW100.EXE or recompiling RAW100.BAS
'
'files that should accompany this program: ASTRNAUT.24
'                                          ASTRNAUT.8
'                                          ASTRNAUT.JPG
'                                          BRUN45.EXE
'                                          FILE_ID.DIZ
'                                          INDEX.TXT
'                                          RAW100.EXE
'                                          RGB.PAL
'                                          RGB100.BAS
'                                          SEE8-100.BAS
'
DEFINT A-Z
colors$ = SPACE$(3 * 10922)
PaletteRGB$ = SPACE$(768)
PRINT "RAW file converter 1.00"
INPUT "Filename to load: ", filein$
OPEN filein$ FOR BINARY AS #1
INPUT "Filename to write: ", fileout$
OPEN fileout$ FOR BINARY AS #2
OPEN "RGB.PAL" FOR BINARY AS #3
GET #3, 1, PaletteRGB$
PRINT
PRINT " In Byte:"
PRINT "Out Byte:"
DO
  GET #1, , colors$
  UseColor$ = ""
  ByteCountEnd% = (LEN(colors$) \ 3)
  FOR ByteCount% = 1 TO ByteCountEnd%
    FirstColor$ = MID$(colors$, (((ByteCount% - 1) * 3) + 1), 1)
    SecondColor$ = MID$(colors$, (((ByteCount% - 1) * 3) + 2), 1)
    ThirdColor$ = MID$(colors$, (((ByteCount% - 1) * 3) + 3), 1)
    Blue% = (ASC(FirstColor$) \ 36)
    Green% = (ASC(SecondColor$) \ 84)
    Red% = (ASC(ThirdColor$) \ 36)
    FOR Count% = 0 TO 255
      SELECT CASE (ASC(MID$(PaletteRGB$, ((Count% * 3) + 1), 1)) \ 36)
        CASE IS = Blue%
          SELECT CASE (ASC(MID$(PaletteRGB$, ((Count% * 3) + 2), 1)) \ 84)
            CASE IS = Green%
              SELECT CASE (ASC(MID$(PaletteRGB$, ((Count% * 3) + 3), 1)) \ 36)
                CASE IS = Red%
                  UseColor$ = UseColor$ + CHR$(Count%)
              END SELECT
          END SELECT
      END SELECT
    NEXT Count%
    InCount& = (Counter& * LEN(colors$)) + (ByteCount% * 3)
    OutCount& = (Counter& * ByteCountEnd%) + LEN(UseColor$)
    LOCATE (CSRLIN - 2), 10
    PRINT STR$(InCount&)
    LOCATE , 10
    PRINT STR$(OutCount&)
    SELECT CASE InCount&
      CASE IS >= LOF(1)
        EXIT FOR
    END SELECT
  NEXT ByteCount%
  PUT #2, , UseColor$
  Counter& = Counter& + 1
LOOP UNTIL EOF(1)
CLOSE #1, #2, #3

